/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.CommonHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetContextHandler {
    private static final Logger log = LoggerFactory.getLogger(AssetContextHandler.class);
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final CommonHandler commonHandler;
    private final List<String> supportedZones;
    private AssetContext graph;

    public AssetContextHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> supportedZones) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.commonHandler = new CommonHandler(serviceName, serverName, invalidParameterHandler, repositoryHelper, repositoryHandler);
        this.supportedZones = supportedZones;
    }

    public AssetContext getAssetContext(String userId, String guid, String type) {
        String methodName = "getAssetContext";
        this.graph = new AssetContext();
        try {
            this.invalidParameterHandler.validateGUID(guid, "guid", "getAssetContext");
            Optional<EntityDetail> entityDetail = this.getEntityDetails(userId, guid, type);
            if (!entityDetail.isPresent()) {
                log.error("Something is wrong in the OMRS Connector when a specific operation is performed in the metadata collection. Entity not found with guid {}", (Object)guid);
                throw new AssetLineageException(AssetLineageErrorCode.ENTITY_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Entity", AssetLineageErrorCode.ENTITY_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getUserAction());
            }
            this.invalidParameterHandler.validateAssetInSupportedZone(guid, "guid", this.commonHandler.getAssetZoneMembership(entityDetail.get().getClassifications()), this.supportedZones, "AssetLineageOmas", "getAssetContext");
            this.buildAssetContext(userId, entityDetail.get());
            return this.graph;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException | PropertyServerException | UserNotAuthorizedException | InvalidParameterException | RepositoryErrorException | org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            throw new AssetLineageException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
        }
    }

    private Optional<EntityDetail> getEntityDetails(String userId, String guid, String type) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        return Optional.ofNullable(this.repositoryHandler.getEntityByGUID(userId, guid, "guid", type, "getEntityDetails"));
    }

    private void buildAssetContext(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        List<EntityDetail> tableTypeEntities;
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("RelationalTable") || typeDefName.equals("DataFile")) {
            this.addContextForSchemaAttributeType(userId, entityDetail, typeDefName);
        }
        if ((tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "AttributeForSchema", typeDefName, false)).isEmpty()) {
            tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "NestedSchemaAttribute", typeDefName, false);
        }
        for (EntityDetail schemaTypeEntity : tableTypeEntities) {
            if (this.isComplexSchemaType(userId, schemaTypeEntity.getType().getTypeDefName())) {
                this.setAssetDetails(userId, schemaTypeEntity);
                continue;
            }
            this.buildAssetContext(userId, (EntityDetail)tableTypeEntities.stream().findFirst().get());
        }
    }

    private List<EntityDetail> buildGraphByRelationshipType(String userId, EntityDetail startEntity, String relationshipType, String typeDefName, boolean changeDirection) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List<Object> relationships = this.commonHandler.getRelationshipsByType(userId, startEntity.getGUID(), relationshipType, typeDefName);
        if (startEntity.getType().getTypeDefName().equals("FileFolder")) {
            relationships = relationships.stream().filter(relationship -> relationship.getEntityTwoProxy().getGUID().equals(startEntity.getGUID())).collect(Collectors.toList());
        }
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship2 : relationships) {
            EntityDetail endEntity = this.commonHandler.buildGraphEdgeByRelationship(userId, startEntity, relationship2, this.graph, changeDirection);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void setAssetDetails(String userId, EntityDetail startEntity) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> assetEntity = this.buildGraphByRelationshipType(userId, startEntity, "AssetSchemaType", startEntity.getType().getTypeDefName(), false);
        Optional first = assetEntity.stream().findFirst();
        if (first.isPresent()) {
            this.buildAsset(userId, (EntityDetail)first.get());
        }
    }

    private void buildAsset(String userId, EntityDetail dataSet) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeDefName = dataSet.getType().getTypeDefName();
        List<EntityDetail> entityDetails = typeDefName.equals("DataFile") ? this.buildGraphByRelationshipType(userId, dataSet, "NestedFile", typeDefName, false) : this.buildGraphByRelationshipType(userId, dataSet, "DataContentForDataSet", typeDefName, false);
        if (CollectionUtils.isEmpty(entityDetails)) {
            return;
        }
        this.addContextForEndpoints(userId, entityDetails.toArray(new EntityDetail[0]));
    }

    private void addContextForEndpoints(String userId, EntityDetail ... entityDetails) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        for (EntityDetail entityDetail : entityDetails) {
            if (entityDetail == null) continue;
            if (entityDetail.getType().getTypeDefName().equals("Database")) {
                this.addContextForConnections(userId, entityDetail);
                continue;
            }
            this.addContextFolderHierarchy(userId, entityDetail);
        }
    }

    private void addContextForConnections(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", "Database", false);
        if (!connections.isEmpty()) {
            for (EntityDetail entity : connections) {
                this.buildGraphByRelationshipType(userId, entity, "ConnectionEndpoint", "Connection", false);
            }
        }
    }

    private void addContextFolderHierarchy(String userId, EntityDetail entityDetail) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Optional nestedFolder;
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", entityDetail.getType().getTypeDefName(), false);
        Optional connection = connections.stream().findFirst();
        if (connection.isPresent()) {
            this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionEndpoint", "Connection", false);
        }
        if ((nestedFolder = this.buildGraphByRelationshipType(userId, entityDetail, "FolderHierarchy", "FileFolder", false).stream().findFirst()).isPresent()) {
            this.addContextFolderHierarchy(userId, (EntityDetail)nestedFolder.get());
        }
    }

    private void addContextForSchemaAttributeType(String userId, EntityDetail entityDetail, String typeDefName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaAttributeTypes = this.buildGraphByRelationshipType(userId, entityDetail, "AssetSchemaType", typeDefName, true);
        if (schemaAttributeTypes.isEmpty()) {
            this.addColumns(userId, "NestedSchemaAttribute", typeDefName, entityDetail);
        }
        this.addColumns(userId, "AttributeForSchema", typeDefName, schemaAttributeTypes.toArray(new EntityDetail[0]));
    }

    private void addColumns(String userId, String relationshipType, String typeDefName, EntityDetail ... entities) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        for (EntityDetail entityDetail : entities) {
            this.buildGraphByRelationshipType(userId, entityDetail, relationshipType, typeDefName, true);
        }
    }

    private boolean isComplexSchemaType(String userId, String typeDefName) throws RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        TypeDefGallery allTypes = this.repositoryHandler.getMetadataCollection().getAllTypes(userId);
        return allTypes.getTypeDefs().stream().anyMatch(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType"));
    }
}

