/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineagePublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetLineagePublisher.class);
    private OpenMetadataTopicConnector connector = null;

    public AssetLineagePublisher(Connection assetLineageOutTopic, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        if (assetLineageOutTopic != null) {
            this.connector = this.getTopicConnector(assetLineageOutTopic, auditLog);
        }
    }

    public void publishRelationshipEvent(AssetLineageEventHeader event) {
        try {
            if (this.connector != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                this.connector.sendEvent(objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (Throwable error) {
            log.error("Unable to publish new asset event: " + event.toString() + "; error was " + error.toString());
        }
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            topicConnector.setAuditLog(auditLog);
            topicConnector.start();
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            log.error("Unable to create topic connector: " + error.toString());
            AssetLineageErrorCode errorCode = AssetLineageErrorCode.BAD_OUT_TOPIC_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{topicConnection.toString(), error.getClass().getName(), error.getMessage()});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

