/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class Validator {
    private OMRSRepositoryHelper repositoryHelper;

    public Validator(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public Set<String> getSuperTypes(String typeDefName) {
        return this.collectSuperTypes("AssetLineageOmas", typeDefName);
    }

    private Set<String> collectSuperTypes(String userId, String typeDefName) {
        HashSet<String> superTypes = new HashSet<String>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
        return superTypes;
    }

    private void collectSuperTypes(String userId, TypeDef type, Set<String> superTypes) {
        if (type.getName().equals("Referenceable")) {
            return;
        }
        superTypes.add(type.getName());
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, type.getSuperType().getName());
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
    }

    public boolean isValidLineageEntityEvent(String typeDefName) {
        List<String> types = Arrays.asList("GlossaryTerm", "TabularColumn", "RelationalColumn", "RelationalTable", "DataFile");
        return types.contains(typeDefName);
    }
}

