/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Constants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationHandler {
    private static final Logger log = LoggerFactory.getLogger(AssetContextHandler.class);
    private InvalidParameterHandler invalidParameterHandler;
    private AssetContext graph;

    public ClassificationHandler(InvalidParameterHandler invalidParameterHandler) {
        this.invalidParameterHandler = invalidParameterHandler;
    }

    public Map<String, Set<GraphContext>> getAssetContextByClassification(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        if (!CollectionUtils.isEmpty((Collection)entityDetail.getClassifications()) && this.checkLineageClassificationTypes(entityDetail)) {
            this.graph = new AssetContext();
            String methodName = "getAssetContextByClassification";
            this.invalidParameterHandler.validateUserId(userId, methodName);
            this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", methodName);
            this.buildGraphContextByClassificationType(entityDetail, this.graph);
            return this.graph.getNeighbors();
        }
        log.info("No valid lineage classification found from entity {} ", (Object)entityDetail.getGUID());
        return null;
    }

    private boolean checkLineageClassificationTypes(EntityDetail entityDetail) {
        for (String classificationType : Constants.immutableQualifiedLineageClassifications) {
            if (!entityDetail.getClassifications().stream().anyMatch(classification -> classification.getName().equals(classificationType))) continue;
            return true;
        }
        return false;
    }

    private List<LineageEntity> buildGraphContextByClassificationType(EntityDetail classifiedEntity, AssetContext graph) throws OCFCheckedExceptionBase {
        ArrayList<LineageEntity> classificationEntities = new ArrayList<LineageEntity>();
        if (classifiedEntity.getStatus() == InstanceStatus.ACTIVE) {
            for (Classification classification : classifiedEntity.getClassifications()) {
                if (!Constants.immutableQualifiedLineageClassifications.contains((Object)classification.getName())) continue;
                LineageEntity lineageClassificationEntity = new LineageEntity();
                lineageClassificationEntity.setGuid(classifiedEntity.getGUID());
                this.mapClassificationsToLineageEntity(classification, lineageClassificationEntity);
                classificationEntities.add(lineageClassificationEntity);
                log.debug("Adding Classification {} ", (Object)classification.toString());
            }
            Converter converter = new Converter();
            LineageEntity startVertex = converter.createLineageEntity(classifiedEntity);
            for (LineageEntity endVertex : classificationEntities) {
                graph.addVertex(startVertex);
                graph.addVertex(endVertex);
                GraphContext edge = new GraphContext(endVertex.getTypeDefName(), startVertex.getGuid(), startVertex, endVertex);
                graph.addEdge(edge);
            }
            return classificationEntities;
        }
        return null;
    }

    private void mapClassificationsToLineageEntity(Classification classification, LineageEntity lineageEntity) throws OCFCheckedExceptionBase {
        String methodName = "mapClassificationsToLineageEntity";
        Converter converter = new Converter();
        try {
            lineageEntity.setVersion(classification.getVersion());
            lineageEntity.setTypeDefName(classification.getType().getTypeDefName());
            lineageEntity.setCreatedBy(classification.getCreatedBy());
            lineageEntity.setUpdatedBy(classification.getUpdatedBy());
            lineageEntity.setCreateTime(classification.getCreateTime());
            lineageEntity.setUpdateTime(classification.getUpdateTime());
            lineageEntity.setProperties(converter.getMapProperties(classification.getProperties()));
            log.debug("Classification mapping for lineage entity {}: ", (Object)lineageEntity);
        }
        catch (Throwable e) {
            AssetLineageErrorCode errorCode = AssetLineageErrorCode.CLASSIFICATION_MAPPING_ERROR;
            String formattedErrorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classification.getName()});
            throw new AssetLineageException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "mapClassificationsToLineageEntity", formattedErrorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

