/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.util.Constants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private AssetLineagePublisher publisher;
    private OMRSAuditLog auditLog;
    private Converter converter = new Converter();

    public AssetLineageOMRSTopicListener(String serverName, String serverUserName, OMRSRepositoryHelper repositoryHelper, OpenMetadataTopicConnector outTopicConnector, OMRSAuditLog auditLog) throws OCFCheckedExceptionBase {
        this.publisher = new AssetLineagePublisher(serverName, serverUserName, repositoryHelper, outTopicConnector);
        this.auditLog = auditLog;
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event" + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - Asset Lineage OMAS is ignoring the event");
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventOriginator == null) {
            return;
        }
        EntityDetail entityDetail = instanceEvent.getEntity();
        try {
            switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.processNewEntity(entityDetail);
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    if (entityDetail.getType().getTypeDefName().equals("Process") && entityDetail.getStatus().getName().equals("Active")) {
                        this.processNewEntity(entityDetail);
                        break;
                    }
                    this.processUpdatedEntity(entityDetail);
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntity(entityDetail);
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            log.error("An exception occurred while processing an OMRSTopic event \n \n" + e.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
        catch (Throwable e) {
            log.error("An exception occurred while processing an OMRSTopic event", e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processNewEntity(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!Constants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug("Asset Lineage OMAS is processing a NewEntity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
        if (entityDetail.getType().getTypeDefName().equals("Process")) {
            this.publisher.publishProcessContext(entityDetail);
        } else {
            this.publisher.publishAssetContext(entityDetail);
        }
    }

    private void processUpdatedEntity(EntityDetail entityDetail) throws ConnectorCheckedException, JsonProcessingException {
        log.debug("Asset Lineage OMAS is processing an UpdatedEntity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.UPDATE_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processDeletedEntity(EntityDetail entityDetail) throws ConnectorCheckedException, JsonProcessingException {
        log.debug("Asset Lineage OMAS is processing a DeleteEntity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DELETE_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!Constants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug("Asset Lineage OMAS is processing a Classified Entity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail);
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail) {
        log.debug("Asset Lineage OMAS is processing a ReClassified Entity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail) {
        log.debug("Asset Lineage OMAS is processing a DeClassified Entity event which contains the following entity {}: ", (Object)entityDetail.getGUID());
    }

    private void processNewRelationship(EntityDetail entityDetail) {
        log.debug("Asset Lineage OMAS is processing a NewRelationship event which contains the following entity {}: ", (Object)entityDetail.getGUID());
    }

    private void processUpdatedRelationshipEvent(EntityDetail entityDetail) {
        log.debug("Asset Lineage OMAS is processing an UpdatedRelationship event which contains the following entity {}: ", (Object)entityDetail.getGUID());
    }

    private void processDeletedRelationshipEvent(EntityDetail entityDetail) {
        log.debug("Asset Lineage OMAS is processing a DeletedRelationship event which contains the following entity {}: ", (Object)entityDetail.getGUID());
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Throwable e) {
        AssetLineageAuditCode auditCode = AssetLineageAuditCode.EVENT_PROCESSING_ERROR;
        this.auditLog.logException("Asset Lineage OMAS is processing an OMRSTopic event.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(instanceEvent.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), e);
    }
}

