/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AssetLineageAuditCode {
    SERVICE_INITIALIZING("OMAS-ASSET-LINEAGE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Lineage Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Lineage OMAS.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INITIALIZED("OMAS-ASSET-LINEAGE-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Lineage Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Asset Lineage OMAS has completed initialization.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_SHUTDOWN("OMAS-ASSET-LINEAGE-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Lineage Open Metadata Access Service (OMAS) is shutting down server instance {0}", "The local server has requested shut down of an Asset Lineage OMAS server instance.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-LINEAGE-0004", OMRSAuditLogRecordSeverity.ERROR, "The Asset Lineage Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    EVENT_PROCESSING_ERROR("OMAS-ASSET-LINEAGE-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "An exception occurred while processing incoming event {0}", "The event could not be processed", "Review the exception to determine the source of the error and correct it.");

    private static final Logger log;
    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private AssetLineageAuditCode(String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String systemAction, String userAction) {
        this.logMessageId = logMessageId;
        this.severity = severity;
        this.logMessage = logMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String getFormattedLogMessage(String ... params) {
        log.debug(String.format("<== OMRS Audit Code.getMessage(%s)", Arrays.toString(params)));
        String result = MessageFormat.format(this.logMessage, params);
        log.debug(String.format("==> OMRS Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    static {
        log = LoggerFactory.getLogger(AssetLineageAuditCode.class);
    }
}

