/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static final String PROCESSING_RELATIONSHIP_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning relationship {}: ";
    private static final String PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning entity {}: ";
    private AssetLineagePublisher publisher;
    private OMRSAuditLog auditLog;
    private Converter converter = new Converter();
    private List<String> lineageClassificationTypes;

    public AssetLineageOMRSTopicListener(OMRSRepositoryHelper repositoryHelper, OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName, List<String> lineageClassificationTypes, OMRSAuditLog auditLog) throws OCFCheckedExceptionBase {
        this.publisher = new AssetLineagePublisher(repositoryHelper, outTopicConnector, serverName, serverUserName);
        this.lineageClassificationTypes = lineageClassificationTypes;
        this.auditLog = auditLog;
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event" + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - Asset Lineage OMAS is ignoring the event");
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        EntityDetail entityDetail = instanceEvent.getEntity();
        Relationship relationship = instanceEvent.getRelationship();
        if (instanceEventOriginator == null) {
            return;
        }
        try {
            switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.processNewEntity(entityDetail);
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    if (entityDetail.getType().getTypeDefName().equals("Process") && entityDetail.getStatus().getName().equals("Active")) {
                        this.processNewEntity(entityDetail);
                        break;
                    }
                    this.processUpdatedEntity(entityDetail);
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntity(entityDetail);
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    this.processClassifiedEntityEvent(entityDetail);
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    this.processReclassifiedEntityEvent(entityDetail);
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    this.processDeclassifiedEntityEvent(entityDetail);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.processNewRelationshipEvent(relationship);
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.processUpdatedRelationshipEvent(relationship);
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.processDeletedRelationshipEvent(relationship);
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            log.error("The following exception occurred: \n" + e.toString() + "\n \nWhile processing OMRSTopic event: \n" + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("An exception occurred while processing OMRSTopic event: \n " + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processNewEntity(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"newEntity", (Object)entityDetail.getGUID());
        if (entityDetail.getType().getTypeDefName().equals("Process")) {
            this.publisher.publishProcessContext(entityDetail);
        } else {
            this.publisher.publishAssetContext(entityDetail);
        }
    }

    private void processUpdatedEntity(EntityDetail entityDetail) throws ConnectorCheckedException, JsonProcessingException {
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"updatedEntity", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.UPDATE_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processDeletedEntity(EntityDetail entityDetail) throws ConnectorCheckedException, JsonProcessingException {
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"deletedEntity", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DELETE_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"classifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail);
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"reclassifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail);
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITYDETAIL_DEBUG_MESSAGE, (Object)"declassifiedEntity", (Object)entityDetail.getGUID());
        if (this.anyLineageClassificationsLeft(entityDetail)) {
            this.publisher.publishClassificationContext(entityDetail);
            return;
        }
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processNewRelationshipEvent(Relationship relationship) throws ConnectorCheckedException, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.NEW_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!"ProcessHierarchy".equals(relationship.getType().getTypeDefName())) {
            return;
        }
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.NEW_RELATIONSHIP_EVENT);
    }

    private void processUpdatedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!AssetLineageConstants.immutableValidLineageRelationshipTypes.contains((Object)relationship.getType().getTypeDefName())) {
            return;
        }
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT);
    }

    private void processDeletedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.DELETE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!AssetLineageConstants.immutableValidLineageRelationshipTypes.contains((Object)relationship.getType().getTypeDefName())) {
            return;
        }
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.DELETE_RELATIONSHIP_EVENT);
    }

    private boolean anyLineageClassificationsLeft(EntityDetail entityDetail) {
        return this.lineageClassificationTypes.stream().anyMatch(classificationType -> entityDetail.getClassifications().stream().anyMatch(classification -> classification.getName().equals(classificationType)));
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Exception e) {
        AssetLineageAuditCode auditCode = AssetLineageAuditCode.EVENT_PROCESSING_ERROR;
        this.auditLog.logException("Asset Lineage OMAS is processing an OMRSTopic event.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(instanceEvent.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
    }
}

