/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.listeners.AssetLineageOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageServicesInstance;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageAdmin
extends AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageAdmin.class);
    private OMRSAuditLog auditLog;
    private AssetLineageServicesInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        AssetLineageAuditCode auditCode = AssetLineageAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), (AuditLog)auditLog);
            List<String> lineageClassificationTypes = this.getLineageClassificationTypes(accessServiceConfig);
            this.instance = new AssetLineageServicesInstance(repositoryConnector, supportedZones, lineageClassificationTypes, serverUserName, auditLog);
            this.serverName = this.instance.getServerName();
            Connection outTopicConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicConnection != null) {
                OpenMetadataTopicConnector outTopicConnector = super.getOutTopicEventBusConnector(outTopicConnection, accessServiceConfig.getAccessServiceName(), (AuditLog)auditLog);
                AssetLineageOMRSTopicListener omrsTopicListener = new AssetLineageOMRSTopicListener(repositoryConnector.getRepositoryHelper(), outTopicConnector, this.serverName, serverUserName, lineageClassificationTypes, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, (AuditLog)auditLog);
            }
            auditCode = AssetLineageAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            log.error("The Asset Lineage OMAS could not be started", (Throwable)error);
            throw error;
        }
        catch (Throwable error) {
            log.error("The Asset Lineage OMAS could not be started", error);
            auditCode = AssetLineageAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), accessServiceConfig.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
    }

    private List<String> getLineageClassificationTypes(AccessServiceConfig accessServiceConfig) {
        Object lineageClassificationTypesProperty = null;
        if (accessServiceConfig.getAccessServiceOptions() != null) {
            lineageClassificationTypesProperty = accessServiceConfig.getAccessServiceOptions().get("LineageClassificationTypes");
        }
        if (lineageClassificationTypesProperty != null) {
            return lineageClassificationTypesProperty;
        }
        return AssetLineageConstants.immutableDefaultLineageClassifications;
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        AssetLineageAuditCode auditCode = AssetLineageAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

