/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

public class ClassificationHandler {
    private InvalidParameterHandler invalidParameterHandler;
    private List<String> lineageClassificationTypes;

    public ClassificationHandler(InvalidParameterHandler invalidParameterHandler, List<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.lineageClassificationTypes = lineageClassificationTypes;
    }

    public Map<String, Set<GraphContext>> buildClassificationContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String methodName = "buildClassificationContext";
        if (entityDetail.getClassifications() == null) {
            return null;
        }
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", methodName);
        Converter converter = new Converter();
        LineageEntity originalEntityVertex = converter.createLineageEntity(entityDetail);
        AssetContext assetContext = new AssetContext();
        assetContext.addVertex(originalEntityVertex);
        for (Classification classification : entityDetail.getClassifications()) {
            if (!this.lineageClassificationTypes.contains(classification.getName())) continue;
            LineageEntity classificationVertex = new LineageEntity();
            String classificationGUID = classification.getName() + entityDetail.getGUID();
            classificationVertex.setGuid(classificationGUID);
            this.copyClassificationProperties(classificationVertex, classification);
            assetContext.addVertex(classificationVertex);
            GraphContext graphContext = new GraphContext(classificationVertex.getTypeDefName(), classificationGUID, originalEntityVertex, classificationVertex);
            assetContext.addGraphContext(graphContext);
        }
        return assetContext.getNeighbors();
    }

    private void copyClassificationProperties(LineageEntity lineageEntity, Classification classification) {
        lineageEntity.setVersion(classification.getVersion());
        InstanceType type = classification.getType();
        if (type != null) {
            lineageEntity.setTypeDefName(type.getTypeDefName());
        }
        lineageEntity.setCreatedBy(classification.getCreatedBy());
        lineageEntity.setUpdatedBy(classification.getUpdatedBy());
        lineageEntity.setCreateTime(classification.getCreateTime());
        lineageEntity.setUpdateTime(classification.getUpdateTime());
        Converter converter = new Converter();
        lineageEntity.setProperties(converter.instancePropertiesToMap(classification.getProperties()));
    }
}

