/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessContextHandler.class);
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final List<String> supportedZones;
    private final HandlerHelper handlerHelper;
    private AssetContext graph;

    public ProcessContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> supportedZones) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler);
        this.supportedZones = supportedZones;
    }

    public Map<String, Set<GraphContext>> getProcessContext(String userId, String processGuid) throws OCFCheckedExceptionBase {
        String methodName = "getProcessContext";
        this.graph = new AssetContext();
        Optional<EntityDetail> entityDetail = this.handlerHelper.getEntityDetails(userId, processGuid, "Process");
        if (!entityDetail.isPresent()) {
            log.error("Entity with guid {} was not found in any metadata repository", (Object)processGuid);
            throw new AssetLineageException(AssetLineageErrorCode.ENTITY_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Entity", AssetLineageErrorCode.ENTITY_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.ENTITY_NOT_FOUND.getUserAction());
        }
        this.invalidParameterHandler.validateAssetInSupportedZone(processGuid, "guid", this.handlerHelper.getAssetZoneMembership(entityDetail.get().getClassifications()), this.supportedZones, "AssetLineageOmas", "getProcessContext");
        return this.checkIfAllRelationshipsExist(userId, entityDetail.get());
    }

    private Map<String, Set<GraphContext>> checkIfAllRelationshipsExist(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        boolean entitiesTillLastRelationshipExist = this.hasEntitiesLinkedWithProcessPort(userId, entityDetail);
        if (entitiesTillLastRelationshipExist) {
            return this.graph.getNeighbors();
        }
        log.error("Some relationships are missing for the entity with guid {}", (Object)entityDetail.getGUID());
        throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationships", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
    }

    private boolean hasEntitiesLinkedWithProcessPort(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        List<EntityDetail> entityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), "ProcessPort", typeDefName);
        if (entityDetails.isEmpty()) {
            log.error("No relationships Process Port has been found for the entity with guid {}", (Object)entityDetail.getGUID());
            throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationship", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
        }
        return this.hasRelationshipBasedOnType(entityDetails, userId);
    }

    private List<EntityDetail> getRelationshipsBetweenEntities(String userId, String guid, String relationshipType, String typeDefName) throws OCFCheckedExceptionBase {
        List<Relationship> relationships = this.handlerHelper.getRelationshipsByType(userId, guid, relationshipType, typeDefName);
        EntityDetail startEntity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", typeDefName, "getRelationships");
        if (startEntity == null) {
            return Collections.emptyList();
        }
        String startEntityType = startEntity.getType().getTypeDefName();
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : relationships) {
            if (relationship.getType().getTypeDefName().equals("AttributeForSchema") && startEntityType.equals("TabularColumn")) continue;
            EntityDetail endEntity = this.handlerHelper.buildGraphEdgeByRelationship(userId, startEntity, relationship, this.graph, false);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private boolean hasRelationshipBasedOnType(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        boolean relationshipsExist = false;
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortAlias")) {
            relationshipsExist = this.hasEndRelationship(entityDetails, userId);
        }
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortImplementation")) {
            relationshipsExist = this.hasTabularSchemaTypes(entityDetails, userId);
        }
        return relationshipsExist;
    }

    private boolean hasEndRelationship(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            result.addAll(this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName()));
        }
        return !result.isEmpty();
    }

    private boolean hasTabularSchemaTypes(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> tabularSchemaType = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName());
            Optional first = tabularSchemaType.stream().findFirst();
            result.add(first.orElse(null));
        }
        return this.hasSchemaAttributes(result, userId);
    }

    private boolean hasSchemaAttributes(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> newListOfEntityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail.getGUID(), (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName()), entityDetail.getType().getTypeDefName());
            result.addAll(newListOfEntityDetails);
        }
        return this.hasEndRelationship(result, userId);
    }

    private boolean checkIfEntityExistWithSpecificType(List<EntityDetail> entityDetails, String typeDefName) {
        return entityDetails.stream().anyMatch(entity -> entity.getType().getTypeDefName().equals(typeDefName));
    }
}

