/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.util;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;

public class Converter {
    public LineageEntity createLineageEntity(EntityDetail entityDetail) {
        LineageEntity lineageEntity = new LineageEntity();
        this.setInstanceHeaderProperties((InstanceHeader)entityDetail, lineageEntity);
        lineageEntity.setProperties(this.instancePropertiesToMap(entityDetail.getProperties()));
        return lineageEntity;
    }

    public LineageRelationship createLineageRelationship(Relationship relationship) {
        LineageRelationship lineageRelationship = new LineageRelationship();
        this.setInstanceHeaderProperties((InstanceHeader)relationship, (LineageEntity)lineageRelationship);
        lineageRelationship.setProperties(this.instancePropertiesToMap(relationship.getProperties()));
        lineageRelationship.setFirstEndGUID(relationship.getEntityTwoProxy().getGUID());
        lineageRelationship.setSecondEndGUID(relationship.getEntityTwoProxy().getGUID());
        return lineageRelationship;
    }

    public Map<String, String> instancePropertiesToMap(InstanceProperties properties) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (properties == null) {
            return attributes;
        }
        Map instanceProperties = properties.getInstanceProperties();
        if (instanceProperties == null) {
            return attributes;
        }
        for (Map.Entry property : instanceProperties.entrySet()) {
            String propertyValue;
            if (property.getValue() == null || (propertyValue = this.propertyValueToString((InstancePropertyValue)property.getValue())).equals("")) continue;
            if (((String)property.getKey()).equals("name")) {
                attributes.put("displayName", propertyValue);
                continue;
            }
            attributes.put((String)property.getKey(), propertyValue);
        }
        return attributes;
    }

    private void setInstanceHeaderProperties(InstanceHeader instanceHeader, LineageEntity lineageEntity) {
        lineageEntity.setGuid(instanceHeader.getGUID());
        lineageEntity.setCreatedBy(instanceHeader.getCreatedBy());
        lineageEntity.setCreateTime(instanceHeader.getCreateTime());
        lineageEntity.setTypeDefName(instanceHeader.getType().getTypeDefName());
        lineageEntity.setUpdatedBy(instanceHeader.getUpdatedBy());
        lineageEntity.setUpdateTime(instanceHeader.getUpdateTime());
        lineageEntity.setVersion(instanceHeader.getVersion());
    }

    private String propertyValueToString(InstancePropertyValue ipv) {
        if (ipv instanceof PrimitivePropertyValue) {
            PrimitiveDefCategory primtype = ((PrimitivePropertyValue)ipv).getPrimitiveDefCategory();
            switch (primtype) {
                case OM_PRIMITIVE_TYPE_STRING: {
                    return (String)((PrimitivePropertyValue)ipv).getPrimitiveValue();
                }
                case OM_PRIMITIVE_TYPE_INT: 
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: 
                case OM_PRIMITIVE_TYPE_BIGINTEGER: 
                case OM_PRIMITIVE_TYPE_BOOLEAN: 
                case OM_PRIMITIVE_TYPE_BYTE: 
                case OM_PRIMITIVE_TYPE_CHAR: 
                case OM_PRIMITIVE_TYPE_DATE: 
                case OM_PRIMITIVE_TYPE_DOUBLE: 
                case OM_PRIMITIVE_TYPE_FLOAT: 
                case OM_PRIMITIVE_TYPE_LONG: 
                case OM_PRIMITIVE_TYPE_SHORT: {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)ipv;
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return ((PrimitivePropertyValue)ipv).getPrimitiveValue().toString();
                    }
                    return "null";
                }
            }
            return "";
        }
        if (ipv instanceof EnumPropertyValue) {
            return ((EnumPropertyValue)ipv).getSymbolicName();
        }
        return "";
    }
}

