/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryContextHandler {
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetContextHandler assetContextHandler;
    private HandlerHelper handlerHelper;

    public GlossaryContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, AssetContextHandler assetContextHandler, List<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.assetContextHandler = assetContextHandler;
    }

    public EntityDetail getGlossaryTermDetails(String userId, String glossaryTermGUID) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getEntityDetails(userId, glossaryTermGUID, "GlossaryTerm");
    }

    public Map<String, Set<GraphContext>> buildGlossaryTermContext(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        String methodName = "buildGlossaryTermContext";
        this.invalidParameterHandler.validateGUID(glossaryTerm.getGUID(), "guid", methodName);
        AssetContext glossaryContext = new AssetContext();
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTerm.getGUID(), glossaryTerm.getType().getTypeDefName(), methodName);
        if (CollectionUtils.isEmpty(semanticAssignments)) {
            return null;
        }
        this.handlerHelper.addLineageClassificationToContext(glossaryTerm, glossaryContext);
        this.addSchemaElementsContext(userId, glossaryTerm, glossaryContext, semanticAssignments);
        return glossaryContext.getNeighbors();
    }

    private void addSchemaElementsContext(String userId, EntityDetail glossaryTerm, AssetContext glossaryContext, List<Relationship> semanticAssignments) throws OCFCheckedExceptionBase {
        Set<EntityDetail> schemaElements = this.addSemanticAssignmentToContext(userId, glossaryTerm, glossaryContext, semanticAssignments);
        for (EntityDetail schemaElement : schemaElements) {
            AssetContext schemaElementContext = this.assetContextHandler.getAssetContext(userId, schemaElement);
            glossaryContext.getGraphContexts().addAll(schemaElementContext.getGraphContexts());
            schemaElementContext.getNeighbors().forEach((k, v) -> this.mergeGraphNeighbors(glossaryContext, (String)k, (Set<GraphContext>)v));
        }
    }

    private void mergeGraphNeighbors(AssetContext glossaryContext, String k, Set<GraphContext> v) {
        if (glossaryContext.getNeighbors().containsKey(k)) {
            ((Set)glossaryContext.getNeighbors().get(k)).addAll(v);
        } else {
            glossaryContext.getNeighbors().put(k, v);
        }
    }

    private Set<EntityDetail> addSemanticAssignmentToContext(String userId, EntityDetail glossaryTerm, AssetContext assetContext, List<Relationship> semanticAssignments) throws OCFCheckedExceptionBase {
        HashSet<EntityDetail> schemaElements = new HashSet<EntityDetail>();
        for (Relationship relationship : semanticAssignments) {
            EntityDetail entityDetail = this.handlerHelper.buildGraphEdgeByRelationship(userId, glossaryTerm, relationship, assetContext);
            schemaElements.add(entityDetail);
        }
        return schemaElements;
    }

    private List<Relationship> getSemanticAssignments(String userId, String glossaryTermGUID, String typeDefName, String methodName) throws UserNotAuthorizedException, PropertyServerException {
        String typeGuid = this.handlerHelper.getTypeByName(userId, "SemanticAssignment");
        return this.repositoryHandler.getRelationshipsByType(userId, glossaryTermGUID, typeDefName, typeGuid, "SemanticAssignment", methodName);
    }
}

