/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class HandlerHelper {
    private static final String GUID_PARAMETER = "guid";
    private static final String ASSET_ZONE_MEMBERSHIP = "AssetZoneMembership";
    private static final String ZONE_MEMBERSHIP = "zoneMembership";
    private List<String> lineageClassificationTypes;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private InvalidParameterHandler invalidParameterHandler;

    public HandlerHelper(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.lineageClassificationTypes = lineageClassificationTypes;
    }

    List<Relationship> getRelationshipsByType(String userId, String assetGuid, String relationshipTypeName, String entityTypeName) throws OCFCheckedExceptionBase {
        String methodName = "getRelationshipsByType";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipsByType");
        this.invalidParameterHandler.validateGUID(assetGuid, GUID_PARAMETER, "getRelationshipsByType");
        String typeGuid = this.getTypeByName(userId, relationshipTypeName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, assetGuid, entityTypeName, typeGuid, relationshipTypeName, "getRelationshipsByType");
        if (relationships != null) {
            return relationships;
        }
        return new ArrayList<Relationship>();
    }

    String getTypeByName(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    private EntityDetail getEntityAtTheEnd(String userId, String entityDetailGUID, Relationship relationship) throws OCFCheckedExceptionBase {
        String methodName = "getEntityAtTheEnd";
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityTwoProxy().getGUID(), GUID_PARAMETER, relationship.getEntityTwoProxy().getType().getTypeDefName(), methodName);
        }
        return this.repositoryHandler.getEntityByGUID(userId, relationship.getEntityOneProxy().getGUID(), GUID_PARAMETER, relationship.getEntityOneProxy().getType().getTypeDefName(), methodName);
    }

    public EntityDetail getEntityDetails(String userId, String entityDetailGUID, String entityTypeName) throws OCFCheckedExceptionBase {
        String methodName = "getEntityDetails";
        return this.repositoryHandler.getEntityByGUID(userId, entityDetailGUID, GUID_PARAMETER, entityTypeName, methodName);
    }

    EntityDetail buildGraphEdgeByRelationship(String userId, EntityDetail startEntity, Relationship relationship, AssetContext graph) throws OCFCheckedExceptionBase {
        LineageEntity endVertex;
        LineageEntity startVertex;
        Converter converter = new Converter(this.repositoryHelper);
        EntityDetail endEntity = this.getEntityAtTheEnd(userId, startEntity.getGUID(), relationship);
        if (endEntity == null) {
            return null;
        }
        if (startEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) {
            startVertex = converter.createLineageEntity(endEntity);
            endVertex = converter.createLineageEntity(startEntity);
        } else {
            startVertex = converter.createLineageEntity(startEntity);
            endVertex = converter.createLineageEntity(endEntity);
        }
        GraphContext graphContext = new GraphContext(relationship.getType().getTypeDefName(), relationship.getGUID(), startVertex, endVertex);
        if (graph.getGraphContexts().stream().noneMatch(e -> e.getRelationshipGuid().equals(graphContext.getRelationshipGuid())) || !graph.getNeighbors().containsKey(graphContext.getRelationshipGuid())) {
            graph.addVertex(startVertex);
            graph.addVertex(endVertex);
            graph.addGraphContext(graphContext);
        }
        return endEntity;
    }

    List<String> getAssetZoneMembership(List<Classification> classifications) {
        List zoneMembership;
        String methodName = "getAssetZoneMembership";
        if (CollectionUtils.isEmpty(classifications)) {
            return Collections.emptyList();
        }
        Optional<Classification> assetZoneMembership = classifications.stream().filter(classification -> classification.getName().equals(ASSET_ZONE_MEMBERSHIP)).findFirst();
        if (assetZoneMembership.isPresent() && CollectionUtils.isNotEmpty((Collection)(zoneMembership = this.repositoryHelper.getStringArrayProperty("AssetLineageOmas", ZONE_MEMBERSHIP, assetZoneMembership.get().getProperties(), methodName)))) {
            return zoneMembership;
        }
        return Collections.emptyList();
    }

    public void addLineageClassificationToContext(EntityDetail entity, AssetContext assetContext) {
        List<Classification> classifications = this.filterLineageClassifications(entity.getClassifications());
        if (CollectionUtils.isNotEmpty(classifications)) {
            this.addClassificationsToGraphContext(classifications, assetContext, entity);
        }
    }

    public List<Classification> filterLineageClassifications(List<Classification> classifications) {
        if (CollectionUtils.isEmpty(classifications)) {
            return Collections.emptyList();
        }
        return classifications.stream().filter(classification -> this.lineageClassificationTypes.contains(classification.getType().getTypeDefName())).collect(Collectors.toList());
    }

    private void addClassificationsToGraphContext(List<Classification> classifications, AssetContext assetContext, EntityDetail entityDetail) {
        Converter converter = new Converter(this.repositoryHelper);
        LineageEntity originalEntityVertex = converter.createLineageEntity(entityDetail);
        assetContext.addVertex(originalEntityVertex);
        String entityGUID = entityDetail.getGUID();
        for (Classification classification : classifications) {
            LineageEntity classificationVertex = this.getClassificationVertex(classification, entityGUID);
            assetContext.addVertex(classificationVertex);
            GraphContext graphContext = new GraphContext("Classification", classificationVertex.getGuid(), originalEntityVertex, classificationVertex);
            assetContext.addGraphContext(graphContext);
        }
    }

    private LineageEntity getClassificationVertex(Classification classification, String entityGUID) {
        LineageEntity classificationVertex = new LineageEntity();
        String classificationGUID = classification.getName() + entityGUID;
        classificationVertex.setGuid(classificationGUID);
        this.copyClassificationProperties(classificationVertex, classification);
        return classificationVertex;
    }

    private void copyClassificationProperties(LineageEntity lineageEntity, Classification classification) {
        lineageEntity.setVersion(classification.getVersion());
        lineageEntity.setTypeDefName(classification.getType().getTypeDefName());
        lineageEntity.setCreatedBy(classification.getCreatedBy());
        lineageEntity.setUpdatedBy(classification.getUpdatedBy());
        lineageEntity.setCreateTime(classification.getCreateTime());
        lineageEntity.setUpdateTime(classification.getUpdateTime());
        Converter converter = new Converter(this.repositoryHelper);
        lineageEntity.setProperties(converter.instancePropertiesToMap(classification.getProperties()));
    }
}

