/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.accessservices.assetlineage.util.SuperTypesRetriever;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessContextHandler.class);
    private final AssetContextHandler assetContextHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final List<String> supportedZones;
    private final HandlerHelper handlerHelper;
    private SuperTypesRetriever superTypesRetriever;
    private AssetContext graph;

    public ProcessContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, AssetContextHandler assetContextHandler, List<String> supportedZones, List<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.assetContextHandler = assetContextHandler;
        this.supportedZones = supportedZones;
        this.superTypesRetriever = new SuperTypesRetriever(repositoryHelper);
    }

    public Map<String, Set<GraphContext>> getProcessContext(String userId, EntityDetail process) throws OCFCheckedExceptionBase {
        String methodName = "getProcessContext";
        this.graph = new AssetContext();
        this.invalidParameterHandler.validateAssetInSupportedZone(process.getGUID(), "guid", this.handlerHelper.getAssetZoneMembership(process.getClassifications()), this.supportedZones, "AssetLineageOmas", "getProcessContext");
        return this.checkIfAllRelationshipsExist(userId, process);
    }

    private Map<String, Set<GraphContext>> checkIfAllRelationshipsExist(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        boolean entitiesTillLastRelationshipExist = this.hasEntitiesLinkedWithProcessPort(userId, entityDetail);
        if (entitiesTillLastRelationshipExist) {
            return this.graph.getNeighbors();
        }
        log.error("Some relationships are missing for the entity with guid {}", (Object)entityDetail.getGUID());
        throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationships", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
    }

    private boolean hasEntitiesLinkedWithProcessPort(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        List<EntityDetail> entityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail, "ProcessPort");
        if (entityDetails.isEmpty()) {
            log.error("No relationships Process Port has been found for the entity with guid {}", (Object)entityDetail.getGUID());
            throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getHTTPErrorCode(), this.getClass().getName(), "Retrieving Relationship", AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getErrorMessage(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getSystemAction(), AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getUserAction());
        }
        return this.hasRelationshipBasedOnType(entityDetails, userId);
    }

    private List<EntityDetail> getRelationshipsBetweenEntities(String userId, EntityDetail startEntity, String relationshipType) throws OCFCheckedExceptionBase {
        if (startEntity == null) {
            return Collections.emptyList();
        }
        this.handlerHelper.addLineageClassificationToContext(startEntity, this.graph);
        String startEntityType = startEntity.getType().getTypeDefName();
        List<Relationship> relationships = this.handlerHelper.getRelationshipsByType(userId, startEntity.getGUID(), relationshipType, startEntityType);
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship : relationships) {
            EntityDetail endEntity = this.handlerHelper.buildGraphEdgeByRelationship(userId, startEntity, relationship, this.graph);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            this.addContextForTabularColumns(userId, endEntity);
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void addContextForTabularColumns(String userId, EntityDetail entity) throws OCFCheckedExceptionBase {
        Set<String> superTypes = this.superTypesRetriever.getSuperTypes(userId, entity.getType().getTypeDefName());
        if (superTypes.contains("TabularColumn")) {
            AssetContext assetContext = this.assetContextHandler.getAssetContext(userId, entity);
            this.graph.getGraphContexts().addAll(assetContext.getGraphContexts());
            assetContext.getNeighbors().forEach(this::mergeGraphNeighbors);
        }
    }

    private void mergeGraphNeighbors(String k, Set<GraphContext> v) {
        if (this.graph.getNeighbors().containsKey(k)) {
            ((Set)this.graph.getNeighbors().get(k)).addAll(v);
        } else {
            this.graph.getNeighbors().put(k, v);
        }
    }

    private boolean hasRelationshipBasedOnType(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        boolean relationshipsExist = false;
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortAlias")) {
            relationshipsExist = this.hasLineageRelationships(entityDetails, userId);
        }
        if (this.checkIfEntityExistWithSpecificType(entityDetails, "PortImplementation")) {
            relationshipsExist = this.hasTabularSchemaTypes(entityDetails, userId);
        }
        return relationshipsExist;
    }

    private boolean hasLineageRelationships(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            result.addAll(this.getRelationshipsBetweenEntities(userId, entityDetail, (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName())));
        }
        return !result.isEmpty();
    }

    private boolean hasTabularSchemaTypes(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> tabularSchemaType = this.getRelationshipsBetweenEntities(userId, entityDetail, (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName()));
            Optional first = tabularSchemaType.stream().findFirst();
            result.add(first.orElse(null));
        }
        return this.hasSchemaAttributes(result, userId);
    }

    private boolean hasSchemaAttributes(List<EntityDetail> entityDetails, String userId) throws OCFCheckedExceptionBase {
        ArrayList<EntityDetail> result = new ArrayList<EntityDetail>();
        for (EntityDetail entityDetail : entityDetails) {
            List<EntityDetail> newListOfEntityDetails = this.getRelationshipsBetweenEntities(userId, entityDetail, (String)AssetLineageConstants.immutableProcessRelationshipsTypes.get((Object)entityDetail.getType().getTypeDefName()));
            result.addAll(newListOfEntityDetails);
        }
        return this.hasLineageRelationships(result, userId);
    }

    private boolean checkIfEntityExistWithSpecificType(List<EntityDetail> entityDetails, String typeDefName) {
        return entityDetails.stream().anyMatch(entity -> entity.getType().getTypeDefName().equals(typeDefName));
    }
}

