/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static final String PROCESSING_RELATIONSHIP_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning relationship {}: ";
    private static final String PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning entity {}: ";
    private AssetLineagePublisher publisher;
    private OMRSAuditLog auditLog;
    private Converter converter;
    private List<String> lineageClassificationTypes;

    public AssetLineageOMRSTopicListener(OMRSRepositoryHelper repositoryHelper, OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName, List<String> lineageClassificationTypes, OMRSAuditLog auditLog) throws OCFCheckedExceptionBase {
        this.publisher = new AssetLineagePublisher(outTopicConnector, serverName, serverUserName);
        this.lineageClassificationTypes = lineageClassificationTypes;
        this.auditLog = auditLog;
        this.converter = new Converter(repositoryHelper);
    }

    public AssetLineagePublisher getPublisher() {
        return this.publisher;
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.debug("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.debug("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event" + instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - Asset Lineage OMAS is ignoring the event");
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        EntityDetail entityDetail = instanceEvent.getEntity();
        Relationship relationship = instanceEvent.getRelationship();
        if (instanceEventOriginator == null) {
            return;
        }
        try {
            switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.processNewEntity(entityDetail);
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    EntityDetail originalEntity = instanceEvent.getOriginalEntity();
                    this.processUpdatedEntity(entityDetail, originalEntity);
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntity(entityDetail);
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    this.processClassifiedEntityEvent(entityDetail);
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    this.processReclassifiedEntityEvent(entityDetail);
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    this.processDeclassifiedEntityEvent(entityDetail);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.processNewRelationshipEvent(relationship);
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.processUpdatedRelationshipEvent(relationship);
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.processDeletedRelationshipEvent(relationship);
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            log.error("The following exception occurred: \n" + e.toString() + "\n \nWhile processing OMRSTopic event: \n" + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("An exception occurred while processing OMRSTopic event: \n " + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processNewEntity(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)typeDefName)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"newEntity", (Object)entityDetail.getGUID());
        if ("Process".equals(typeDefName)) {
            this.publisher.publishProcessContext(entityDetail);
        }
    }

    private void processUpdatedEntity(EntityDetail entityDetail, EntityDetail originalEntity) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"updatedEntity", (Object)entityDetail.getGUID());
        if (this.isProcessStatusChangedToActive(entityDetail, originalEntity)) {
            this.publisher.publishProcessContext(entityDetail);
        } else {
            LineageEvent event = new LineageEvent();
            event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
            event.setAssetLineageEventType(AssetLineageEventType.UPDATE_ENTITY_EVENT);
            this.publisher.publishEvent((AssetLineageEventHeader)event);
        }
    }

    private boolean isProcessStatusChangedToActive(EntityDetail entityDetail, EntityDetail originalEntity) {
        return entityDetail.getType().getTypeDefName().equals("Process") && !originalEntity.getStatus().getName().equals(entityDetail.getStatus().getName()) && entityDetail.getStatus().getName().equals("Active");
    }

    private void processDeletedEntity(EntityDetail entityDetail) throws ConnectorCheckedException, JsonProcessingException {
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"deletedEntity", (Object)entityDetail.getGUID());
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DELETE_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        if (!this.anyLineageClassificationsLeft(entityDetail)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"classifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT);
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        if (!this.anyLineageClassificationsLeft(entityDetail)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"reclassifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.RECLASSIFIED_ENTITY_EVENT);
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"declassifiedEntity", (Object)entityDetail.getGUID());
        if (this.anyLineageClassificationsLeft(entityDetail)) {
            this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
            return;
        }
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(this.converter.createLineageEntity(entityDetail));
        event.setAssetLineageEventType(AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
        this.publisher.publishEvent((AssetLineageEventHeader)event);
    }

    private void processNewRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.NEW_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityOneProxy().getType().getTypeDefName()) && !AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityTwoProxy().getType().getTypeDefName())) {
            return;
        }
        String relationshipType = relationship.getType().getTypeDefName();
        if ("SemanticAssignment".equals(relationshipType)) {
            String glossaryTermGUID = relationship.getEntityTwoProxy().getGUID();
            this.publisher.publishGlossaryContext(glossaryTermGUID);
        } else if (!"ProcessHierarchy".equals(relationshipType)) {
            this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.NEW_RELATIONSHIP_EVENT);
        }
    }

    private void processUpdatedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!AssetLineageConstants.immutableValidLineageRelationshipTypes.contains((Object)relationship.getType().getTypeDefName())) {
            return;
        }
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityOneProxy().getType().getTypeDefName()) && !AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityTwoProxy().getType().getTypeDefName())) {
            return;
        }
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT);
    }

    private void processDeletedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.DELETE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        if (!AssetLineageConstants.immutableValidLineageRelationshipTypes.contains((Object)relationship.getType().getTypeDefName())) {
            return;
        }
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityOneProxy().getType().getTypeDefName()) && !AssetLineageConstants.immutableValidLineageEntityEvents.contains((Object)relationship.getEntityTwoProxy().getType().getTypeDefName())) {
            return;
        }
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.DELETE_RELATIONSHIP_EVENT);
    }

    private boolean anyLineageClassificationsLeft(EntityDetail entityDetail) {
        if (CollectionUtils.isEmpty((Collection)entityDetail.getClassifications())) {
            return false;
        }
        List classificationNames = entityDetail.getClassifications().stream().map(classification -> classification.getType().getTypeDefName()).collect(Collectors.toList());
        return !Collections.disjoint(this.lineageClassificationTypes, classificationNames);
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Exception e) {
        AssetLineageAuditCode auditCode = AssetLineageAuditCode.EVENT_PROCESSING_ERROR;
        this.auditLog.logException("Asset Lineage OMAS is processing an OMRSTopic event.", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(instanceEvent.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
    }
}

