/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageRestServices.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public AssetLineageRestServices() {
        instanceHandler.registerAccessService();
    }

    public GUIDListResponse publishEntities(String serverName, String userId, String entityType) {
        GUIDListResponse response = new GUIDListResponse();
        String methodName = "publishEntities";
        try {
            AssetContextHandler assetContextHandler = instanceHandler.getAssetContextHandler(userId, serverName, methodName);
            List<EntityDetail> entitiesByTypeName = assetContextHandler.getEntitiesByTypeName(userId, entityType);
            if (CollectionUtils.isEmpty(entitiesByTypeName)) {
                return response;
            }
            AssetLineagePublisher publisher = instanceHandler.getAssetLineagePublisher(userId, serverName, methodName);
            if (publisher == null) {
                log.debug("Asset Lineage Publisher is not available. The context event for {} could not be published on the Asset Lineage OMAS Out Topic.", (Object)entityType);
                return response;
            }
            List<String> publishedEntitiesContext = this.publishEntitiesContext(entityType, entitiesByTypeName, publisher);
            response.setGUIDs(publishedEntitiesContext);
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
        }
        return response;
    }

    private List<String> publishEntitiesContext(String typeName, List<EntityDetail> entitiesByType, AssetLineagePublisher publisher) {
        ArrayList<String> publishedGUIDs = new ArrayList<String>();
        for (EntityDetail entityDetail : entitiesByType) {
            try {
                Map<String, Set<GraphContext>> context;
                if ("GlossaryTerm".equals(typeName)) {
                    context = publisher.publishGlossaryContext(entityDetail);
                    this.collectGUID(publishedGUIDs, entityDetail, context);
                    continue;
                }
                if ("Process".equals(typeName)) {
                    context = publisher.publishProcessContext(entityDetail);
                    this.collectGUID(publishedGUIDs, entityDetail, context);
                    continue;
                }
                log.error("Unsupported typeName {} for entity with guid {}. The context can not be published", (Object)typeName, (Object)entityDetail.getGUID());
            }
            catch (JsonProcessingException | OCFCheckedExceptionBase ocfCheckedExceptionBase) {
                ocfCheckedExceptionBase.printStackTrace();
            }
        }
        return publishedGUIDs;
    }

    private void collectGUID(List<String> publishedGUIDs, EntityDetail entityDetail, Map<String, Set<GraphContext>> context) {
        if (MapUtils.isNotEmpty(context)) {
            publishedGUIDs.add(entityDetail.getGUID());
        }
    }
}

