/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OCFOMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetLineageServicesInstance
extends OCFOMASServiceInstance {
    private static AccessServiceDescription myDescription = AccessServiceDescription.ASSET_LINEAGE_OMAS;
    private GlossaryContextHandler glossaryContextHandler;
    private AssetContextHandler assetContextHandler;
    private ProcessContextHandler processContextHandler;
    private ClassificationHandler classificationHandler;
    private AssetLineagePublisher assetLineagePublisher;

    public AssetLineageServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, Set<String> lineageClassificationTypes, String localServerUserId, AuditLog auditLog) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, auditLog, localServerUserId, repositoryConnector.getMaxPageSize());
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "AssetLineageServicesInstance";
            throw new NewInstanceException(AssetLineageErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        this.assetContextHandler = new AssetContextHandler(this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, supportedZones, lineageClassificationTypes);
        this.processContextHandler = new ProcessContextHandler(this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.assetContextHandler, supportedZones, lineageClassificationTypes);
        this.glossaryContextHandler = new GlossaryContextHandler(this.invalidParameterHandler, this.repositoryHelper, this.repositoryHandler, this.assetContextHandler, lineageClassificationTypes);
        this.classificationHandler = new ClassificationHandler(this.invalidParameterHandler, lineageClassificationTypes, this.repositoryHelper);
    }

    GlossaryContextHandler getGlossaryContextHandler() {
        return this.glossaryContextHandler;
    }

    AssetContextHandler getAssetContextHandler() {
        return this.assetContextHandler;
    }

    ProcessContextHandler getProcessContextHandler() {
        return this.processContextHandler;
    }

    ClassificationHandler getClassificationHandler() {
        return this.classificationHandler;
    }

    public AssetLineagePublisher getAssetLineagePublisher() {
        return this.assetLineagePublisher;
    }

    public void setAssetLineagePublisher(AssetLineagePublisher assetLineagePublisher) {
        this.assetLineagePublisher = assetLineagePublisher;
    }
}

