/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.util;

import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SuperTypesRetriever {
    private OMRSRepositoryHelper repositoryHelper;

    public SuperTypesRetriever(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public Set<String> getSuperTypes(String userId, String typeDefName) {
        return this.collectSuperTypes(userId, typeDefName);
    }

    private Set<String> collectSuperTypes(String userId, String typeDefName) {
        HashSet<String> superTypes = new HashSet<String>();
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
        return superTypes;
    }

    private void collectSuperTypes(String userId, TypeDef type, Set<String> superTypes) {
        if (type.getName().equals("Referenceable")) {
            return;
        }
        superTypes.add(type.getName());
        if (type.getSuperType() == null) {
            return;
        }
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, type.getSuperType().getName());
        if (typeDefByName != null) {
            this.collectSuperTypes(userId, typeDefByName, superTypes);
        }
    }
}

