/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryContextHandler {
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetContextHandler assetContextHandler;
    private HandlerHelper handlerHelper;

    public GlossaryContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, AssetContextHandler assetContextHandler, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.assetContextHandler = assetContextHandler;
    }

    public EntityDetail getGlossaryTermDetails(String userId, String glossaryTermGUID) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getEntityDetails(userId, glossaryTermGUID, "GlossaryTerm");
    }

    public Map<String, Set<GraphContext>> buildGlossaryTermContext(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        String methodName = "buildGlossaryTermContext";
        String glossaryTermGUID = glossaryTerm.getGUID();
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "guid", methodName);
        AssetContext glossaryContext = new AssetContext();
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTermGUID, "GlossaryTerm");
        List<Relationship> termCategorization = this.getTermCategorizations(userId, glossaryTermGUID, "GlossaryTerm");
        if (CollectionUtils.isEmpty(semanticAssignments) && CollectionUtils.isEmpty(termCategorization)) {
            return null;
        }
        this.handlerHelper.addLineageClassificationToContext(glossaryTerm, glossaryContext);
        this.addSchemaElementsContext(userId, glossaryTerm, glossaryContext, semanticAssignments);
        this.addGlossaryCategories(userId, glossaryTerm, glossaryContext, termCategorization);
        return glossaryContext.getNeighbors();
    }

    private void addSchemaElementsContext(String userId, EntityDetail glossaryTerm, AssetContext glossaryContext, List<Relationship> semanticAssignments) throws OCFCheckedExceptionBase {
        if (CollectionUtils.isEmpty(semanticAssignments)) {
            return;
        }
        Set<EntityDetail> schemaElements = this.addGlossaryTermRelationshipsToContext(userId, glossaryTerm, glossaryContext, semanticAssignments);
        for (EntityDetail schemaElement : schemaElements) {
            AssetContext schemaElementContext = this.assetContextHandler.getAssetContext(userId, schemaElement);
            glossaryContext.getGraphContexts().addAll(schemaElementContext.getGraphContexts());
            schemaElementContext.getNeighbors().forEach((k, v) -> this.mergeGraphNeighbors(glossaryContext, (String)k, (Set<GraphContext>)v));
        }
    }

    private void addGlossaryCategories(String userId, EntityDetail glossaryTerm, AssetContext glossaryContext, List<Relationship> termCategorization) throws OCFCheckedExceptionBase {
        if (CollectionUtils.isEmpty(termCategorization)) {
            return;
        }
        this.addGlossaryTermRelationshipsToContext(userId, glossaryTerm, glossaryContext, termCategorization);
    }

    private void mergeGraphNeighbors(AssetContext glossaryContext, String k, Set<GraphContext> v) {
        if (glossaryContext.getNeighbors().containsKey(k)) {
            ((Set)glossaryContext.getNeighbors().get(k)).addAll(v);
        } else {
            glossaryContext.getNeighbors().put(k, v);
        }
    }

    private Set<EntityDetail> addGlossaryTermRelationshipsToContext(String userId, EntityDetail glossaryTerm, AssetContext assetContext, List<Relationship> relationships) throws OCFCheckedExceptionBase {
        HashSet<EntityDetail> endEntityDetails = new HashSet<EntityDetail>();
        for (Relationship relationship : relationships) {
            EntityDetail entityDetail = this.handlerHelper.buildGraphEdgeByRelationship(userId, glossaryTerm, relationship, assetContext);
            endEntityDetails.add(entityDetail);
        }
        return endEntityDetails;
    }

    private List<Relationship> getSemanticAssignments(String userId, String entityTypeGUID, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, entityTypeGUID, entityTypeName, "SemanticAssignment");
    }

    private List<Relationship> getTermCategorizations(String userId, String entityGUID, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, entityGUID, entityTypeName, "TermCategorization");
    }

    private List<Relationship> getRelationshipsByTypeGUID(String userId, String entityGUID, String entityTypeName, String relationshipTypeName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipsByTypeGUID";
        String relationshipTypeGUID = this.handlerHelper.getTypeByName(userId, relationshipTypeName);
        List relationshipsByType = this.repositoryHandler.getRelationshipsByType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (CollectionUtils.isEmpty((Collection)relationshipsByType)) {
            return Collections.emptyList();
        }
        return relationshipsByType.stream().filter(relationship -> relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null).collect(Collectors.toList());
    }

    public boolean hasGlossaryTermLineageRelationships(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        String entityDetailGUID = entityDetail.getGUID();
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, entityDetailGUID, typeDefName);
        if (CollectionUtils.isNotEmpty(semanticAssignments)) {
            return true;
        }
        return CollectionUtils.isNotEmpty(this.getTermCategorizations(userId, entityDetailGUID, entityDetail.getType().getTypeDefGUID()));
    }
}

