/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.outtopic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineagePublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetLineagePublisher.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private OpenMetadataTopicConnector outTopicConnector;
    private String serverUserName;
    private ProcessContextHandler processContextHandler;
    private ClassificationHandler classificationHandler;
    private GlossaryContextHandler glossaryHandler;

    public AssetLineagePublisher(OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName) throws OCFCheckedExceptionBase {
        String methodName = "AssetLineagePublisher";
        this.outTopicConnector = outTopicConnector;
        this.serverUserName = serverUserName;
        this.processContextHandler = instanceHandler.getProcessHandler(serverUserName, serverName, methodName);
        this.classificationHandler = instanceHandler.getClassificationHandler(serverUserName, serverName, methodName);
        this.glossaryHandler = instanceHandler.getGlossaryHandler(serverUserName, serverName, methodName);
    }

    public Map<String, Set<GraphContext>> publishProcessContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Map<String, Set<GraphContext>> processContext = this.processContextHandler.getProcessContext(this.serverUserName, entityDetail);
        if (MapUtils.isEmpty(processContext)) {
            log.debug("Context not found for the entity {} ", (Object)entityDetail.getGUID());
            return Collections.emptyMap();
        }
        this.publishLineageEvent(processContext, AssetLineageEventType.PROCESS_CONTEXT_EVENT);
        return processContext;
    }

    public void publishGlossaryContext(String glossaryTermGUID) throws OCFCheckedExceptionBase, JsonProcessingException {
        EntityDetail entityDetail = this.glossaryHandler.getGlossaryTermDetails(this.serverUserName, glossaryTermGUID);
        this.publishGlossaryContext(entityDetail);
    }

    public Map<String, Set<GraphContext>> publishGlossaryContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Map<String, Set<GraphContext>> context = this.glossaryHandler.buildGlossaryTermContext(this.serverUserName, entityDetail);
        if (MapUtils.isEmpty(context)) {
            log.debug("Context not found for the entity {} ", (Object)entityDetail.getGUID());
            return Collections.emptyMap();
        }
        this.publishLineageEvent(context, AssetLineageEventType.GLOSSARY_TERM_CONTEXT_EVENT);
        return context;
    }

    public void publishClassificationContext(EntityDetail entityDetail, AssetLineageEventType assetLineageEventType) throws OCFCheckedExceptionBase, JsonProcessingException {
        Map<String, Set<GraphContext>> classificationContext = this.classificationHandler.buildClassificationContext(entityDetail);
        if (MapUtils.isEmpty(classificationContext)) {
            log.debug("Lineage classifications not found for the entity {} ", (Object)entityDetail.getGUID());
            return;
        }
        this.publishLineageEvent(classificationContext, assetLineageEventType);
    }

    public void publishLineageRelationshipEvent(LineageRelationship lineageRelationship, AssetLineageEventType eventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageRelationshipEvent event = new LineageRelationshipEvent();
        event.setLineageRelationship(lineageRelationship);
        event.setAssetLineageEventType(eventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishEvent(AssetLineageEventHeader event) throws JsonProcessingException, ConnectorCheckedException {
        if (this.outTopicConnector == null) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        this.outTopicConnector.sendEvent(objectMapper.writeValueAsString((Object)event));
        log.debug("Asset Lineage OMAS has published an event of type {} ", (Object)event.getAssetLineageEventType());
    }

    public void publishLineageEntityEvent(LineageEntity lineageEntity, AssetLineageEventType lineageEventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageEvent event = new LineageEvent();
        event.setLineageEntity(lineageEntity);
        event.setAssetLineageEventType(lineageEventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public boolean isEntityEligibleForPublishing(EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("GlossaryCategory") || typeDefName.equals("GlossaryTerm")) {
            return this.glossaryHandler.hasGlossaryTermLineageRelationships(this.serverUserName, entityDetail);
        }
        return true;
    }

    private void publishLineageEvent(Map<String, Set<GraphContext>> context, AssetLineageEventType lineageEventType) throws JsonProcessingException, ConnectorCheckedException {
        LineageEvent event = new LineageEvent();
        event.setAssetContext(context);
        event.setAssetLineageEventType(lineageEventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }
}

