/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageRestServices.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public AssetLineageRestServices() {
        instanceHandler.registerAccessService();
    }

    public GUIDListResponse publishEntities(String serverName, String userId, String entityType) {
        GUIDListResponse response = new GUIDListResponse();
        String methodName = "publishEntities";
        try {
            AssetContextHandler assetContextHandler = instanceHandler.getAssetContextHandler(userId, serverName, methodName);
            List<EntityDetail> entitiesByTypeName = assetContextHandler.getEntitiesByTypeName(userId, entityType);
            if (CollectionUtils.isEmpty(entitiesByTypeName)) {
                return response;
            }
            log.debug("Asset Lineage OMAS found {} entities with type {}", (Object)entitiesByTypeName.size(), (Object)entityType);
            AssetLineagePublisher publisher = instanceHandler.getAssetLineagePublisher(userId, serverName, methodName);
            if (publisher == null) {
                log.debug("Asset Lineage Publisher is not available. The context event for {} could not be published on the Asset Lineage OMAS Out Topic.", (Object)entityType);
                return response;
            }
            List<String> publishedEntitiesContext = this.publishEntitiesContext(entitiesByTypeName, publisher);
            response.setGUIDs(publishedEntitiesContext);
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        catch (JsonProcessingException | OCFCheckedExceptionBase e) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, e, methodName);
        }
        return response;
    }

    private List<String> publishEntitiesContext(List<EntityDetail> entitiesByType, AssetLineagePublisher publisher) throws JsonProcessingException, OCFCheckedExceptionBase {
        ArrayList<String> publishedGUIDs = new ArrayList<String>();
        log.debug("Asset Lineage OMAS is publishing entities context");
        for (EntityDetail entityDetail : entitiesByType) {
            publishedGUIDs.add(this.publishEntityContext(entityDetail, publisher));
        }
        log.debug("Asset Lineage OMAS published entities context");
        CollectionUtils.filter(publishedGUIDs, (Predicate)PredicateUtils.notNullPredicate());
        return publishedGUIDs;
    }

    private String publishEntityContext(EntityDetail entityDetail, AssetLineagePublisher publisher) throws OCFCheckedExceptionBase, JsonProcessingException {
        String typeName = entityDetail.getType().getTypeDefName();
        Map<Object, Object> context = new HashMap();
        switch (typeName) {
            case "GlossaryTerm": {
                context = publisher.publishGlossaryContext(entityDetail);
                break;
            }
            case "Process": {
                context = publisher.publishProcessContext(entityDetail);
                break;
            }
            default: {
                log.error("Unsupported typeName {} for entity with guid {}. The context can not be published", (Object)typeName, (Object)entityDetail.getGUID());
            }
        }
        if (MapUtils.isNotEmpty(context)) {
            return entityDetail.getGUID();
        }
        return null;
    }
}

