/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.admin;

import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.listeners.AssetLineageOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageServicesInstance;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageAdmin
extends AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageAdmin.class);
    private AuditLog auditLog;
    private AssetLineageServicesInstance instance;
    private String serverName;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", AssetLineageAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            List supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions(), accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            Set<String> lineageClassificationTypes = this.getLineageClassificationTypes(accessServiceConfigurationProperties);
            this.instance = new AssetLineageServicesInstance(repositoryConnector, supportedZones, lineageClassificationTypes, serverUserName, auditLog);
            this.serverName = this.instance.getServerName();
            Connection outTopicConnection = accessServiceConfigurationProperties.getAccessServiceOutTopic();
            if (outTopicConnection != null) {
                OpenMetadataTopicConnector outTopicConnector = super.getOutTopicEventBusConnector(outTopicConnection, accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
                AssetLineageOMRSTopicListener omrsTopicListener = new AssetLineageOMRSTopicListener(repositoryConnector.getRepositoryHelper(), outTopicConnector, this.serverName, serverUserName, lineageClassificationTypes, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfigurationProperties.getAccessServiceName(), this.serverName, enterpriseOMRSTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
                this.instance.setAssetLineagePublisher(omrsTopicListener.getPublisher());
            }
            auditLog.logMessage("initialize", AssetLineageAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.serverName));
        }
        catch (OMAGConfigurationErrorException error) {
            log.error("The Asset Lineage OMAS could not be started", (Throwable)error);
            throw error;
        }
        catch (Throwable error) {
            log.error("The Asset Lineage OMAS could not be started", error);
            auditLog.logException("initialize", AssetLineageAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage(), this.serverName), error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_LINEAGE_OMAS.getAccessServiceFullName(), error);
        }
    }

    private Set<String> getLineageClassificationTypes(AccessServiceConfig accessServiceConfig) {
        Object lineageClassificationTypesProperty;
        if (accessServiceConfig.getAccessServiceOptions() != null && (lineageClassificationTypesProperty = accessServiceConfig.getAccessServiceOptions().get("LineageClassificationTypes")) != null) {
            return (Set)lineageClassificationTypesProperty;
        }
        return AssetLineageConstants.immutableDefaultLineageClassifications;
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            this.auditLog.logMessage("shutdown", AssetLineageAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
        }
    }
}

