/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class AssetContextHandler {
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final HandlerHelper handlerHelper;
    private final List<String> supportedZones;
    private AssetContext graph;

    public AssetContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> supportedZones, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.supportedZones = supportedZones;
    }

    public List<EntityDetail> getEntitiesByTypeName(String userId, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEntitiesByTypeName";
        String typeDefGUID = this.handlerHelper.getTypeByName(userId, entityTypeName);
        return this.repositoryHandler.getEntitiesByType(userId, typeDefGUID, 0, 0, "getEntitiesByTypeName");
    }

    public EntityDetail getEntityByTypeAndGuid(String userId, String guid, String entityTypeName) {
        EntityDetail entityDetails = null;
        try {
            entityDetails = this.handlerHelper.getEntityDetails(userId, guid, entityTypeName);
        }
        catch (OCFCheckedExceptionBase ocfCheckedExceptionBase) {
            ocfCheckedExceptionBase.printStackTrace();
        }
        return entityDetails;
    }

    public AssetContext getAssetContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String methodName = "getAssetContext";
        this.graph = new AssetContext();
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", "getAssetContext");
        this.invalidParameterHandler.validateAssetInSupportedZone(entityDetail.getGUID(), "guid", this.handlerHelper.getAssetZoneMembership(entityDetail.getClassifications()), this.supportedZones, "AssetLineageOmas", "getAssetContext");
        this.buildAssetContext(userId, entityDetail);
        return this.graph;
    }

    private void buildAssetContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("RelationalTable") || typeDefName.equals("DataFile")) {
            this.addContextForSchemaAttributeType(userId, entityDetail);
        }
        this.addLineageMappings(userId, entityDetail, typeDefName);
        List<EntityDetail> tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "AttributeForSchema", typeDefName);
        if (tableTypeEntities.isEmpty()) {
            tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "NestedSchemaAttribute", typeDefName);
        }
        for (EntityDetail schemaTypeEntity : tableTypeEntities) {
            if (this.isComplexSchemaType(userId, schemaTypeEntity.getType().getTypeDefName())) {
                this.setAssetDetails(userId, schemaTypeEntity);
                continue;
            }
            Optional first = tableTypeEntities.stream().findFirst();
            if (!first.isPresent()) continue;
            this.buildAssetContext(userId, (EntityDetail)first.get());
        }
    }

    private void addLineageMappings(String userId, EntityDetail entityDetail, String typeDefName) throws OCFCheckedExceptionBase {
        List<Relationship> relationships = this.handlerHelper.getRelationshipsByType(userId, entityDetail.getGUID(), "LineageMapping", typeDefName);
        for (Relationship relationship : relationships) {
            this.handlerHelper.buildGraphEdgeByRelationship(userId, entityDetail, relationship, this.graph);
        }
    }

    private List<EntityDetail> buildGraphByRelationshipType(String userId, EntityDetail entityDetail, String relationshipType, String typeDefName) throws OCFCheckedExceptionBase {
        this.handlerHelper.addLineageClassificationToContext(entityDetail, this.graph);
        List<Object> relationships = this.handlerHelper.getRelationshipsByType(userId, entityDetail.getGUID(), relationshipType, typeDefName);
        if (entityDetail.getType().getTypeDefName().equals("FileFolder")) {
            relationships = relationships.stream().filter(relationship -> relationship.getEntityTwoProxy().getGUID().equals(entityDetail.getGUID())).collect(Collectors.toList());
        }
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship2 : relationships) {
            EntityDetail endEntity = this.handlerHelper.buildGraphEdgeByRelationship(userId, entityDetail, relationship2, this.graph);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void setAssetDetails(String userId, EntityDetail complexSchemaType) throws OCFCheckedExceptionBase {
        List<EntityDetail> assetEntity = this.buildGraphByRelationshipType(userId, complexSchemaType, "AssetSchemaType", complexSchemaType.getType().getTypeDefName());
        Optional first = assetEntity.stream().findFirst();
        if (first.isPresent()) {
            this.buildAsset(userId, (EntityDetail)first.get());
        }
    }

    private void buildAsset(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        String relationshipType = typeDefName.equals("DataFile") ? "NestedFile" : "DataContentForDataSet";
        List<EntityDetail> entityDetails = this.buildGraphByRelationshipType(userId, entityDetail, relationshipType, typeDefName);
        if (CollectionUtils.isEmpty(entityDetails)) {
            return;
        }
        this.addContextForEndpoints(userId, entityDetails.toArray(new EntityDetail[0]));
    }

    private void addContextForEndpoints(String userId, EntityDetail ... entityDetails) throws OCFCheckedExceptionBase {
        for (EntityDetail entityDetail : entityDetails) {
            if (entityDetail == null) continue;
            if (entityDetail.getType().getTypeDefName().equals("Database")) {
                this.addContextForConnections(userId, entityDetail);
                continue;
            }
            this.addContextFolderHierarchy(userId, entityDetail);
        }
    }

    private void addContextForConnections(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", "Database");
        if (!connections.isEmpty()) {
            for (EntityDetail entity : connections) {
                this.buildGraphByRelationshipType(userId, entity, "ConnectionEndpoint", "Connection");
            }
        }
    }

    private void addContextFolderHierarchy(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        Optional nestedFolder;
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", entityDetail.getType().getTypeDefName());
        Optional connection = connections.stream().findFirst();
        if (connection.isPresent()) {
            this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionEndpoint", "Connection");
        }
        if ((nestedFolder = this.buildGraphByRelationshipType(userId, entityDetail, "FolderHierarchy", "FileFolder").stream().findFirst()).isPresent()) {
            this.addContextFolderHierarchy(userId, (EntityDetail)nestedFolder.get());
        }
    }

    private void addContextForSchemaAttributeType(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        List<EntityDetail> schemaAttributeTypes = this.buildGraphByRelationshipType(userId, entityDetail, "AssetSchemaType", typeDefName);
        if (schemaAttributeTypes.isEmpty()) {
            this.addColumns(userId, "NestedSchemaAttribute", typeDefName, entityDetail);
        }
        this.addColumns(userId, "AttributeForSchema", typeDefName, schemaAttributeTypes.toArray(new EntityDetail[0]));
    }

    private void addColumns(String userId, String relationshipType, String typeDefName, EntityDetail ... entities) throws OCFCheckedExceptionBase {
        for (EntityDetail entityDetail : entities) {
            this.buildGraphByRelationshipType(userId, entityDetail, relationshipType, typeDefName);
        }
    }

    private boolean isComplexSchemaType(String userId, String typeDefName) throws RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        TypeDefGallery allTypes = this.repositoryHandler.getMetadataCollection().getAllTypes(userId);
        return allTypes.getTypeDefs().stream().anyMatch(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType"));
    }
}

