/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.AssetContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class AssetContextHandler {
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final HandlerHelper handlerHelper;
    private final List<String> supportedZones;

    public AssetContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> supportedZones, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.supportedZones = supportedZones;
    }

    public List<EntityDetail> getEntitiesByTypeName(String userId, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEntitiesByTypeName";
        String typeDefGUID = this.handlerHelper.getTypeByName(userId, entityTypeName);
        return this.repositoryHandler.getEntitiesByType(userId, typeDefGUID, 0, 0, "getEntitiesByTypeName");
    }

    public EntityDetail getEntityByTypeAndGuid(String userId, String guid, String entityTypeName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.handlerHelper.getEntityDetails(userId, guid, entityTypeName);
    }

    public AssetContext getAssetContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String methodName = "getAssetContext";
        AssetContext graph = new AssetContext();
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", "getAssetContext");
        this.invalidParameterHandler.validateAssetInSupportedZone(entityDetail.getGUID(), "guid", this.handlerHelper.getAssetZoneMembership(entityDetail.getClassifications()), this.supportedZones, "AssetLineageOmas", "getAssetContext");
        this.buildAssetContext(userId, entityDetail, graph);
        return graph;
    }

    private void buildAssetContext(String userId, EntityDetail entityDetail, AssetContext assetContext) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("RelationalTable") || typeDefName.equals("DataFile")) {
            this.addContextForSchemaAttributeType(userId, entityDetail, assetContext);
        }
        this.addLineageMappings(userId, entityDetail, typeDefName, assetContext);
        List<EntityDetail> tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "AttributeForSchema", typeDefName, assetContext);
        if (tableTypeEntities.isEmpty()) {
            tableTypeEntities = this.buildGraphByRelationshipType(userId, entityDetail, "NestedSchemaAttribute", typeDefName, assetContext);
        }
        for (EntityDetail schemaTypeEntity : tableTypeEntities) {
            if (this.isComplexSchemaType(userId, schemaTypeEntity.getType().getTypeDefName())) {
                this.setAssetDetails(userId, schemaTypeEntity, assetContext);
                continue;
            }
            Optional first = tableTypeEntities.stream().findFirst();
            if (!first.isPresent()) continue;
            this.buildAssetContext(userId, (EntityDetail)first.get(), assetContext);
        }
    }

    private void addLineageMappings(String userId, EntityDetail entityDetail, String typeDefName, AssetContext assetContext) throws OCFCheckedExceptionBase {
        List<Relationship> relationships = this.handlerHelper.getRelationshipsByType(userId, entityDetail.getGUID(), "LineageMapping", typeDefName);
        for (Relationship relationship : relationships) {
            this.handlerHelper.buildGraphEdgeByRelationship(userId, entityDetail, relationship, assetContext);
        }
    }

    private List<EntityDetail> buildGraphByRelationshipType(String userId, EntityDetail entityDetail, String relationshipType, String typeDefName, AssetContext assetContext) throws OCFCheckedExceptionBase {
        this.handlerHelper.addLineageClassificationToContext(entityDetail, assetContext);
        List<Object> relationships = this.handlerHelper.getRelationshipsByType(userId, entityDetail.getGUID(), relationshipType, typeDefName);
        if (entityDetail.getType().getTypeDefName().equals("FileFolder")) {
            relationships = relationships.stream().filter(relationship -> relationship.getEntityTwoProxy().getGUID().equals(entityDetail.getGUID())).collect(Collectors.toList());
        }
        ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
        for (Relationship relationship2 : relationships) {
            EntityDetail endEntity = this.handlerHelper.buildGraphEdgeByRelationship(userId, entityDetail, relationship2, assetContext);
            if (endEntity == null) {
                return Collections.emptyList();
            }
            entityDetails.add(endEntity);
        }
        return entityDetails;
    }

    private void setAssetDetails(String userId, EntityDetail complexSchemaType, AssetContext assetContext) throws OCFCheckedExceptionBase {
        List<EntityDetail> assetEntity = this.buildGraphByRelationshipType(userId, complexSchemaType, "AssetSchemaType", complexSchemaType.getType().getTypeDefName(), assetContext);
        Optional first = assetEntity.stream().findFirst();
        if (first.isPresent()) {
            this.buildAsset(userId, (EntityDetail)first.get(), assetContext);
        }
    }

    private void buildAsset(String userId, EntityDetail entityDetail, AssetContext assetContext) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        String relationshipType = typeDefName.equals("DataFile") ? "NestedFile" : "DataContentForDataSet";
        List<EntityDetail> entityDetails = this.buildGraphByRelationshipType(userId, entityDetail, relationshipType, typeDefName, assetContext);
        if (CollectionUtils.isEmpty(entityDetails)) {
            return;
        }
        this.addContextForEndpoints(userId, assetContext, entityDetails.toArray(new EntityDetail[0]));
    }

    private void addContextForEndpoints(String userId, AssetContext assetContext, EntityDetail ... entityDetails) throws OCFCheckedExceptionBase {
        for (EntityDetail entityDetail : entityDetails) {
            if (entityDetail == null) continue;
            if (entityDetail.getType().getTypeDefName().equals("Database")) {
                this.addContextForConnections(userId, entityDetail, assetContext);
                continue;
            }
            this.addContextFolderHierarchy(userId, entityDetail, assetContext);
        }
    }

    private void addContextForConnections(String userId, EntityDetail entityDetail, AssetContext assetContext) throws OCFCheckedExceptionBase {
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", "Database", assetContext);
        if (!connections.isEmpty()) {
            for (EntityDetail entity : connections) {
                this.buildGraphByRelationshipType(userId, entity, "ConnectionEndpoint", "Connection", assetContext);
            }
        }
    }

    private void addContextFolderHierarchy(String userId, EntityDetail entityDetail, AssetContext assetContext) throws OCFCheckedExceptionBase {
        Optional nestedFolder;
        List<EntityDetail> connections = this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionToAsset", entityDetail.getType().getTypeDefName(), assetContext);
        Optional connection = connections.stream().findFirst();
        if (connection.isPresent()) {
            this.buildGraphByRelationshipType(userId, entityDetail, "ConnectionEndpoint", "Connection", assetContext);
        }
        if ((nestedFolder = this.buildGraphByRelationshipType(userId, entityDetail, "FolderHierarchy", "FileFolder", assetContext).stream().findFirst()).isPresent()) {
            this.addContextFolderHierarchy(userId, (EntityDetail)nestedFolder.get(), assetContext);
        }
    }

    private void addContextForSchemaAttributeType(String userId, EntityDetail entityDetail, AssetContext assetContext) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        List<EntityDetail> schemaAttributeTypes = this.buildGraphByRelationshipType(userId, entityDetail, "AssetSchemaType", typeDefName, assetContext);
        if (schemaAttributeTypes.isEmpty()) {
            this.addColumns(userId, "NestedSchemaAttribute", typeDefName, assetContext, entityDetail);
        }
        this.addColumns(userId, "AttributeForSchema", typeDefName, assetContext, schemaAttributeTypes.toArray(new EntityDetail[0]));
    }

    private void addColumns(String userId, String relationshipType, String typeDefName, AssetContext assetContext, EntityDetail ... entities) throws OCFCheckedExceptionBase {
        for (EntityDetail entityDetail : entities) {
            this.buildGraphByRelationshipType(userId, entityDetail, relationshipType, typeDefName, assetContext);
        }
    }

    private boolean isComplexSchemaType(String userId, String typeDefName) throws RepositoryErrorException, InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        TypeDefGallery allTypes = this.repositoryHandler.getMetadataCollection().getAllTypes(userId);
        return allTypes.getTypeDefs().stream().anyMatch(t -> t.getName().equals(typeDefName) && t.getSuperType().getName().equals("ComplexSchemaType"));
    }
}

