/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ClassificationHandler {
    private InvalidParameterHandler invalidParameterHandler;
    private HandlerHelper handlerHelper;

    public ClassificationHandler(InvalidParameterHandler invalidParameterHandler, Set<String> lineageClassificationTypes, OMRSRepositoryHelper repositoryHelper) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, null, lineageClassificationTypes);
    }

    public Map<String, RelationshipsContext> buildClassificationContext(EntityDetail entityDetail, AssetLineageEventType assetLineageEventType) throws OCFCheckedExceptionBase {
        String methodName = "buildClassificationContext";
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", methodName);
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        context.put(assetLineageEventType.getEventTypeName(), this.handlerHelper.buildContextForLineageClassifications(entityDetail));
        return context;
    }
}

