/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryContextHandler {
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private HandlerHelper handlerHelper;

    public GlossaryContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
    }

    public EntityDetail getGlossaryTermDetails(String userId, String glossaryTermGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.handlerHelper.getEntityDetails(userId, glossaryTermGUID, "GlossaryTerm");
    }

    public Map<String, RelationshipsContext> buildGlossaryTermContext(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        String methodName = "buildGlossaryTermContext";
        String glossaryTermGUID = glossaryTerm.getGUID();
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "guid", methodName);
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTermGUID, "GlossaryTerm");
        List<Relationship> termCategorizations = this.getTermCategorizations(userId, glossaryTermGUID, "GlossaryTerm");
        List<Relationship> glossaries = this.getTermAnchors(userId, glossaryTermGUID);
        if (Stream.of(semanticAssignments, termCategorizations, glossaries).allMatch(CollectionUtils::isEmpty)) {
            return Collections.emptyMap();
        }
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        context.put(AssetLineageEventType.SEMANTIC_ASSIGNMENTS_EVENT.getEventTypeName(), this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, semanticAssignments));
        context.put(AssetLineageEventType.TERM_CATEGORIZATIONS_EVENT.getEventTypeName(), this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, termCategorizations));
        context.put(AssetLineageEventType.TERM_ANCHORS_EVENT.getEventTypeName(), this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, glossaries));
        List<Relationship> glossariesForCategories = this.getGlossariesForCategories(userId, glossaryTermGUID, termCategorizations);
        context.put(AssetLineageEventType.CATEGORY_ANCHORS_EVENT.getEventTypeName(), this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, glossariesForCategories));
        context.put(AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT.getEventTypeName(), this.handlerHelper.buildContextForLineageClassifications(glossaryTerm));
        return context;
    }

    private List<Relationship> getGlossariesForCategories(String userId, String glossaryTermGUID, List<Relationship> termCategorization) throws OCFCheckedExceptionBase {
        ArrayList<Relationship> categories = new ArrayList<Relationship>();
        for (Relationship relationship : termCategorization) {
            if (glossaryTermGUID.equals(relationship.getEntityOneProxy().getGUID())) {
                categories.addAll(this.getCategoryAnchor(userId, relationship.getEntityTwoProxy().getGUID()));
                continue;
            }
            categories.addAll(this.getCategoryAnchor(userId, relationship.getEntityOneProxy().getGUID()));
        }
        return categories;
    }

    private List<Relationship> getSemanticAssignments(String userId, String entityTypeGUID, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, entityTypeGUID, entityTypeName, "SemanticAssignment");
    }

    private List<Relationship> getTermCategorizations(String userId, String entityGUID, String entityTypeName) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, entityGUID, entityTypeName, "TermCategorization");
    }

    private List<Relationship> getTermAnchors(String userId, String entityGUID) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, entityGUID, "GlossaryTerm", "TermAnchor");
    }

    private List<Relationship> getCategoryAnchor(String userId, String categoryGUID) throws UserNotAuthorizedException, PropertyServerException {
        return this.getRelationshipsByTypeGUID(userId, categoryGUID, "GlossaryCategory", "CategoryAnchor");
    }

    private List<Relationship> getRelationshipsByTypeGUID(String userId, String entityGUID, String entityTypeName, String relationshipTypeName) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipsByTypeGUID";
        String relationshipTypeGUID = this.handlerHelper.getTypeByName(userId, relationshipTypeName);
        List relationshipsByType = this.repositoryHandler.getRelationshipsByType(userId, entityGUID, entityTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (CollectionUtils.isEmpty((Collection)relationshipsByType)) {
            return Collections.emptyList();
        }
        return relationshipsByType.stream().filter(relationship -> relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null).collect(Collectors.toList());
    }

    public boolean hasGlossaryTermLineageRelationships(String userId, EntityDetail entityDetail) throws UserNotAuthorizedException, PropertyServerException {
        String typeDefName = entityDetail.getType().getTypeDefName();
        String entityDetailGUID = entityDetail.getGUID();
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, entityDetailGUID, typeDefName);
        if (CollectionUtils.isNotEmpty(semanticAssignments)) {
            return true;
        }
        return CollectionUtils.isNotEmpty(this.getTermCategorizations(userId, entityDetailGUID, entityDetail.getType().getTypeDefGUID()));
    }

    public Set<EntityDetail> getSchemaElementsAttached(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTerm.getGUID(), "GlossaryTerm");
        HashSet<EntityDetail> schemaElements = new HashSet<EntityDetail>();
        for (Relationship semanticAssignment : semanticAssignments) {
            schemaElements.add(this.handlerHelper.getEntityAtTheEnd(userId, glossaryTerm.getGUID(), semanticAssignment));
        }
        return schemaElements;
    }
}

