/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.FindEntitiesParameters;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageRestServices.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public AssetLineageRestServices() {
        instanceHandler.registerAccessService();
    }

    public GUIDListResponse publishEntities(String serverName, String userId, String entityType, FindEntitiesParameters findEntitiesParameters) {
        GUIDListResponse response = new GUIDListResponse();
        String methodName = "publishEntities";
        try {
            HandlerHelper handlerHelper = instanceHandler.getHandlerHelper(userId, serverName, methodName);
            SearchProperties searchProperties = handlerHelper.getSearchPropertiesAfterUpdateTime(findEntitiesParameters.getUpdatedAfter());
            List<EntityDetail> entitiesByTypeName = handlerHelper.findEntitiesByType(userId, entityType, searchProperties, findEntitiesParameters);
            return this.publishEntitiesContext(userId, serverName, entityType, entitiesByTypeName);
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        return response;
    }

    private GUIDListResponse publishEntitiesContext(String userId, String serverName, String entityType, List<EntityDetail> entitiesByTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishEntitiesContext";
        AuditLog auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
        GUIDListResponse response = new GUIDListResponse();
        if (entitiesByTypeName == null || CollectionUtils.isEmpty(entitiesByTypeName)) {
            auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISH_PROCESS_INFO.getMessageDefinition("ENTITIES_NOT_FOUND", entityType, "0"));
            return response;
        }
        auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISH_PROCESS_INFO.getMessageDefinition("ENTITIES_FOUND", entityType, String.valueOf(entitiesByTypeName.size())));
        auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISH_PROCESS_INFO.getMessageDefinition("ENTITIES", entityType, entitiesByTypeName.stream().map(InstanceHeader::getGUID).collect(Collectors.joining(","))));
        AssetLineagePublisher publisher = instanceHandler.getAssetLineagePublisher(userId, serverName, methodName);
        if (publisher == null) {
            auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISHER_NOT_AVAILABLE_ERROR.getMessageDefinition());
            return response;
        }
        auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISH_PROCESS_INFO.getMessageDefinition("PUBLISH_SEQUENCE_START", entityType, String.valueOf(entitiesByTypeName.size())));
        List<String> publishedEntitiesContext = this.publishEntitiesContext(entitiesByTypeName, publisher, auditLog);
        response.setGUIDs(publishedEntitiesContext);
        auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISH_PROCESS_INFO.getMessageDefinition("PUBLISH_SEQUENCE_END", entityType, String.valueOf(publishedEntitiesContext.size())));
        return response;
    }

    public GUIDListResponse publishEntity(String serverName, String userId, String entityType, String guid) {
        GUIDListResponse response = new GUIDListResponse();
        String methodName = "publishEntity";
        try {
            AuditLog auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            HandlerHelper handlerHelper = instanceHandler.getHandlerHelper(userId, serverName, methodName);
            EntityDetail entity = handlerHelper.getEntityDetails(userId, guid, entityType);
            if (entity == null) {
                auditLog.logMessage(methodName, AssetLineageAuditCode.ENTITY_INFO.getMessageDefinition("ENTITY_NOT_FOUND", entityType, guid));
                return response;
            }
            auditLog.logMessage(methodName, AssetLineageAuditCode.ENTITY_INFO.getMessageDefinition("ENTITY_FOUND", entityType, guid));
            AssetLineagePublisher publisher = instanceHandler.getAssetLineagePublisher(userId, serverName, methodName);
            if (publisher == null) {
                auditLog.logMessage(methodName, AssetLineageAuditCode.PUBLISHER_NOT_AVAILABLE_ERROR.getMessageDefinition());
                return response;
            }
            String publishedEntitiesContext = this.publishEntityContext(publisher, entity, auditLog);
            response.setGUIDs(Collections.singletonList(publishedEntitiesContext));
        }
        catch (InvalidParameterException e) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
        }
        catch (UserNotAuthorizedException e) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
        }
        catch (PropertyServerException e) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
        }
        return response;
    }

    private List<String> publishEntitiesContext(List<EntityDetail> entitiesByType, AssetLineagePublisher publisher, AuditLog auditLog) {
        List<String> publishedGUIDs = entitiesByType.parallelStream().map(entityDetail -> this.publishEntityContext(publisher, (EntityDetail)entityDetail, auditLog)).collect(Collectors.toList());
        CollectionUtils.filter(publishedGUIDs, (Predicate)PredicateUtils.notNullPredicate());
        return publishedGUIDs;
    }

    private String publishEntityContext(AssetLineagePublisher publisher, EntityDetail entityDetail, AuditLog auditLog) {
        String methodName = "publishEntityContext";
        try {
            auditLog.logMessage(methodName, AssetLineageAuditCode.ENTITY_INFO.getMessageDefinition("BUILDING_CONTEXT_STARTED", entityDetail.getType().getTypeDefName(), entityDetail.getGUID()));
            String result = this.publishContext(entityDetail, publisher);
            auditLog.logMessage(methodName, AssetLineageAuditCode.ENTITY_INFO.getMessageDefinition("PUBLISHED", entityDetail.getType().getTypeDefName(), entityDetail.getGUID()));
            return result;
        }
        catch (Exception e) {
            auditLog.logMessage(methodName, AssetLineageAuditCode.ENTITY_INFO.getMessageDefinition("FAILED_TO_PUBLISH", entityDetail.getType().getTypeDefName(), entityDetail.getGUID()));
            auditLog.logException(methodName, AssetLineageAuditCode.ENTITY_ERROR.getMessageDefinition(entityDetail.getType().getTypeDefName(), entityDetail.getGUID()), (Throwable)e);
            return null;
        }
    }

    private String publishContext(EntityDetail entityDetail, AssetLineagePublisher publisher) throws OCFCheckedExceptionBase, JsonProcessingException {
        String typeName;
        switch (typeName = entityDetail.getType().getTypeDefName()) {
            case "GlossaryTerm": {
                Map<String, RelationshipsContext> glossaryContext = publisher.publishGlossaryContext(entityDetail);
                if (glossaryContext == null) break;
                return entityDetail.getGUID();
            }
            case "Process": {
                Map<String, Set<GraphContext>> processContext = publisher.publishProcessContext(entityDetail);
                if (processContext == null) break;
                return entityDetail.getGUID();
            }
            default: {
                log.error("Unsupported typeName {} for entity with guid {}. The context can not be published", (Object)typeName, (Object)entityDetail.getGUID());
            }
        }
        return null;
    }
}

