/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageConstants;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static final String PROCESSING_RELATIONSHIP_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning relationship {} ";
    private static final String PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning entity {} ";
    private final AssetLineagePublisher publisher;
    private final AuditLog auditLog;
    private final Converter converter;
    private final Set<String> lineageClassificationTypes;
    private final String serverName;

    public AssetLineageOMRSTopicListener(OMRSRepositoryHelper repositoryHelper, OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName, Set<String> lineageClassificationTypes, AuditLog auditLog) throws OCFCheckedExceptionBase {
        this.publisher = new AssetLineagePublisher(outTopicConnector, serverName, serverUserName);
        this.lineageClassificationTypes = lineageClassificationTypes;
        this.auditLog = auditLog;
        this.serverName = serverName;
        this.converter = new Converter(repositoryHelper);
    }

    public AssetLineagePublisher getPublisher() {
        return this.publisher;
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.trace("Ignoring registry event: " + event.toString());
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.trace("Ignoring type event: " + event.toString());
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        if (instanceEvent == null) {
            return;
        }
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventOriginator == null) {
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        EntityDetail entityDetail = instanceEvent.getEntity();
        Relationship relationship = instanceEvent.getRelationship();
        try {
            switch (instanceEventType) {
                case UPDATED_ENTITY_EVENT: {
                    EntityDetail originalEntity = instanceEvent.getOriginalEntity();
                    this.processUpdatedEntity(entityDetail, originalEntity);
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntity(entityDetail);
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    this.processClassifiedEntityEvent(entityDetail);
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    this.processReclassifiedEntityEvent(entityDetail);
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    this.processDeclassifiedEntityEvent(entityDetail);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.processNewRelationshipEvent(relationship);
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.processUpdatedRelationshipEvent(relationship);
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.processDeletedRelationshipEvent(relationship);
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            log.error("The following exception occurred: \n" + e.toString() + "\n \nWhile processing OMRSTopic event: \n" + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("An exception occurred while processing OMRSTopic event: \n " + instanceEvent.toString(), (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processUpdatedEntity(EntityDetail entityDetail, EntityDetail originalEntity) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains(entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"updatedEntity", (Object)entityDetail.getGUID());
        if (this.isProcessStatusChangedToActive(entityDetail, originalEntity)) {
            this.publisher.publishProcessContext(entityDetail);
            log.info("Asset Lineage OMAS published the context for process with guid {}", (Object)entityDetail.getGUID());
        } else {
            this.publishEntityEvent(entityDetail, AssetLineageEventType.UPDATE_ENTITY_EVENT);
        }
    }

    private void processDeletedEntity(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains(entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"deletedEntity", (Object)entityDetail.getGUID());
        this.publishEntityEvent(entityDetail, AssetLineageEventType.DELETE_ENTITY_EVENT);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains(entityDetail.getType().getTypeDefName())) {
            return;
        }
        if (!this.anyLineageClassificationsLeft(entityDetail)) {
            return;
        }
        if (!this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"classifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT);
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains(entityDetail.getType().getTypeDefName())) {
            return;
        }
        if (!this.anyLineageClassificationsLeft(entityDetail)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"reclassifiedEntity", (Object)entityDetail.getGUID());
        this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.RECLASSIFIED_ENTITY_EVENT);
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!AssetLineageConstants.immutableValidLineageEntityEvents.contains(entityDetail.getType().getTypeDefName())) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, (Object)"declassifiedEntity", (Object)entityDetail.getGUID());
        if (this.anyLineageClassificationsLeft(entityDetail)) {
            this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
            return;
        }
        this.publishEntityEvent(entityDetail, AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
    }

    private void publishEntityEvent(EntityDetail entityDetail, AssetLineageEventType lineageEventType) throws JsonProcessingException, OCFCheckedExceptionBase {
        if (this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            this.publisher.publishLineageEntityEvent(this.converter.createLineageEntity(entityDetail), lineageEventType);
        }
    }

    private void processNewRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        String relationshipType;
        if (!this.isLineageRelationship(relationship)) {
            return;
        }
        switch (relationshipType = relationship.getType().getTypeDefName()) {
            case "SemanticAssignment": 
            case "TermCategorization": {
                log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.NEW_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
                String glossaryTermGUID = relationship.getEntityTwoProxy().getGUID();
                this.publisher.publishGlossaryContext(glossaryTermGUID);
                break;
            }
            case "ProcessHierarchy": 
            case "LineageMapping": {
                log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.NEW_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
                this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.NEW_RELATIONSHIP_EVENT);
                break;
            }
        }
    }

    private void processUpdatedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!this.isLineageRelationship(relationship)) {
            return;
        }
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT);
    }

    private boolean isLineageRelationship(Relationship relationship) {
        if (!this.isRelationshipValid(relationship).booleanValue()) {
            return false;
        }
        if (!AssetLineageConstants.immutableValidLineageRelationshipTypes.contains(relationship.getType().getTypeDefName())) {
            return false;
        }
        return AssetLineageConstants.immutableValidLineageEntityEvents.contains(relationship.getEntityOneProxy().getType().getTypeDefName()) || AssetLineageConstants.immutableValidLineageEntityEvents.contains(relationship.getEntityTwoProxy().getType().getTypeDefName());
    }

    private void processDeletedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!this.isLineageRelationship(relationship)) {
            return;
        }
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, (Object)AssetLineageEventType.DELETE_RELATIONSHIP_EVENT.getEventTypeName(), (Object)relationship.getGUID());
        this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.DELETE_RELATIONSHIP_EVENT);
    }

    private boolean isProcessStatusChangedToActive(EntityDetail entityDetail, EntityDetail originalEntity) {
        return entityDetail.getType().getTypeDefName().equals("Process") && !originalEntity.getStatus().getName().equals(entityDetail.getStatus().getName()) && entityDetail.getStatus().getName().equals("Active");
    }

    private boolean anyLineageClassificationsLeft(EntityDetail entityDetail) {
        if (CollectionUtils.isEmpty((Collection)entityDetail.getClassifications())) {
            return false;
        }
        List classificationNames = entityDetail.getClassifications().stream().map(classification -> classification.getType().getTypeDefName()).collect(Collectors.toList());
        return !Collections.disjoint(this.lineageClassificationTypes, classificationNames);
    }

    private Boolean isRelationshipValid(Relationship relationship) {
        return relationship.getType() != null && relationship.getType().getTypeDefName() != null && relationship.getEntityOneProxy() != null && relationship.getEntityOneProxy().getType() != null && relationship.getEntityOneProxy().getType().getTypeDefName() != null && relationship.getEntityTwoProxy() != null && relationship.getEntityTwoProxy().getType() != null && relationship.getEntityTwoProxy().getType().getTypeDefName() != null;
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Exception e) {
        String actionDescription = "Asset Lineage OMAS is unable to process an OMRSTopic event.";
        this.auditLog.logException(actionDescription, AssetLineageAuditCode.EVENT_PROCESSING_EXCEPTION.getMessageDefinition(e.getMessage(), this.serverName), instanceEvent.toString(), (Throwable)e);
    }
}

