/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.outtopic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipsEvent;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineagePublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetLineagePublisher.class);
    private static AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private final OpenMetadataTopicConnector outTopicConnector;
    private final String serverUserName;
    private final ProcessContextHandler processContextHandler;
    private final ClassificationHandler classificationHandler;
    private final GlossaryContextHandler glossaryHandler;

    public AssetLineagePublisher(OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName) throws OCFCheckedExceptionBase {
        String methodName = "AssetLineagePublisher";
        this.outTopicConnector = outTopicConnector;
        this.serverUserName = serverUserName;
        this.processContextHandler = instanceHandler.getProcessHandler(serverUserName, serverName, methodName);
        this.classificationHandler = instanceHandler.getClassificationHandler(serverUserName, serverName, methodName);
        this.glossaryHandler = instanceHandler.getGlossaryHandler(serverUserName, serverName, methodName);
    }

    public Multimap<String, RelationshipsContext> publishProcessContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Multimap<String, RelationshipsContext> processContext = this.processContextHandler.buildProcessContext(this.serverUserName, entityDetail);
        if (processContext.isEmpty()) {
            log.info("Context not found for the entity {} ", (Object)entityDetail.getGUID());
        }
        this.publishLineageRelationshipsEvents(processContext);
        return processContext;
    }

    public void publishGlossaryContext(String glossaryTermGUID) throws OCFCheckedExceptionBase, JsonProcessingException {
        EntityDetail entityDetail = this.glossaryHandler.getGlossaryTermDetails(this.serverUserName, glossaryTermGUID);
        this.publishGlossaryContext(entityDetail);
    }

    public Multimap<String, RelationshipsContext> publishGlossaryContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Multimap<String, RelationshipsContext> glossaryTermContext = this.glossaryHandler.buildGlossaryTermContext(this.serverUserName, entityDetail);
        if (glossaryTermContext.isEmpty()) {
            log.info("Context not found for the entity {} ", (Object)entityDetail.getGUID());
        }
        this.publishLineageRelationshipsEvents(glossaryTermContext);
        return glossaryTermContext;
    }

    private void publishLineageRelationshipsEvents(Multimap<String, RelationshipsContext> contextMap) throws JsonProcessingException, ConnectorCheckedException {
        for (String eventType : contextMap.keySet()) {
            for (RelationshipsContext relationshipsContext : contextMap.get((Object)eventType)) {
                if (!CollectionUtils.isNotEmpty((Collection)relationshipsContext.getRelationships())) continue;
                LineageRelationshipsEvent event = new LineageRelationshipsEvent();
                event.setRelationshipsContext(relationshipsContext);
                event.setAssetLineageEventType(AssetLineageEventType.getByEventTypeName((String)eventType));
                this.publishEvent((AssetLineageEventHeader)event);
            }
        }
    }

    public void publishClassificationContext(EntityDetail entityDetail, AssetLineageEventType assetLineageEventType) throws OCFCheckedExceptionBase, JsonProcessingException {
        Map<String, RelationshipsContext> classificationContext = this.classificationHandler.buildClassificationContext(entityDetail, assetLineageEventType);
        if (MapUtils.isEmpty(classificationContext)) {
            log.debug("Lineage classifications not found for the entity {} ", (Object)entityDetail.getGUID());
            return;
        }
        this.publishLineageRelationshipsEvents((Multimap<String, RelationshipsContext>)Multimaps.forMap(classificationContext));
    }

    public void publishLineageRelationshipEvent(LineageRelationship lineageRelationship, AssetLineageEventType eventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageRelationshipEvent event = new LineageRelationshipEvent();
        event.setLineageRelationship(lineageRelationship);
        event.setAssetLineageEventType(eventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishEvent(AssetLineageEventHeader event) throws JsonProcessingException, ConnectorCheckedException {
        if (this.outTopicConnector == null) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        this.outTopicConnector.sendEvent(objectMapper.writeValueAsString((Object)event));
    }

    public void publishLineageEntityEvent(LineageEntity lineageEntity, AssetLineageEventType lineageEventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageEntityEvent event = new LineageEntityEvent();
        event.setLineageEntity(lineageEntity);
        event.setAssetLineageEventType(lineageEventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public boolean isEntityEligibleForPublishing(EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("GlossaryCategory") || typeDefName.equals("GlossaryTerm")) {
            return this.glossaryHandler.hasGlossaryTermLineageRelationships(this.serverUserName, entityDetail);
        }
        return true;
    }
}

