/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetLineageAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-ASSET-LINEAGE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Lineage Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Lineage OMAS.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INITIALIZED("OMAS-ASSET-LINEAGE-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Lineage Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The Asset Lineage OMAS has completed initialization.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_SHUTDOWN("OMAS-ASSET-LINEAGE-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Lineage Open Metadata Access Service (OMAS) is shutting down server instance {0}", "The local server has requested shut down of an Asset Lineage OMAS server instance.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-LINEAGE-0004", OMRSAuditLogRecordSeverity.ERROR, "The Asset Lineage Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    EVENT_PROCESSING_EXCEPTION("OMAS-ASSET-LINEAGE-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "An exception occurred while processing incoming event {0}", "The event could not be processed", "Review the exception to determine the source of the error and correct it."),
    PUBLISH_PROCESS_INFO("OMAS-ASSET-LINEAGE-0006", OMRSAuditLogRecordSeverity.INFO, "{0} Processing sequence entity type {1} items {2}", "The Asset Lineage OMAS records information about processing sequence.", "No action is required."),
    ENTITY_INFO("OMAS-ASSET-LINEAGE-0007", OMRSAuditLogRecordSeverity.INFO, "{0} Entity type {1} guid {2}", "The Asset Lineage OMAS records information about entity.", "No action is required."),
    ENTITY_ERROR("OMAS-ASSET-LINEAGE-0008", OMRSAuditLogRecordSeverity.ERROR, "Error processing entity type {0} guid {1}", "The Asset Lineage OMAS records error while processing entity.", "Review the error message and check the entity in question to determine the cause of the problem."),
    PUBLISHER_NOT_AVAILABLE_ERROR("OMAS-ASSET-LINEAGE-0009", OMRSAuditLogRecordSeverity.ERROR, "AssetLineagePublisher instance not available.", "The Asset Lineage OMAS will not publish entity.", "Possible configuration error; Contact the server administrator to check accessServiceOutTopic connection configuration before tying again."),
    ASSET_CONTEXT_INFO("OMAS-ASSET-LINEAGE-0010", OMRSAuditLogRecordSeverity.INFO, "The asset context for the entity with guid {0} is requested through REST endpoint and will be retrieved on the out topic.", "The Asset Lineage OMAS retrieves entity's asset context.", "No action is required.");

    private AuditLogMessageDefinition messageDefinition;

    private AssetLineageAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "AssetLineageAuditCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

