/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetContextHandler {
    private final RepositoryHandler repositoryHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final HandlerHelper handlerHelper;
    private final List<String> supportedZones;

    public AssetContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, List<String> supportedZones, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.supportedZones = supportedZones;
    }

    public Map<String, RelationshipsContext> buildSchemaElementContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName;
        String methodName = "buildSchemaElementContext";
        this.handlerHelper.validateAsset(entityDetail, "buildSchemaElementContext", this.supportedZones);
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        HashSet<GraphContext> columnContext = new HashSet<GraphContext>();
        switch (typeDefName = entityDetail.getType().getTypeDefName()) {
            case "TabularColumn": {
                if (this.isInternalTabularColumn(userId, entityDetail)) break;
                EntityDetail schemaType = this.handlerHelper.addContextForRelationships(userId, entityDetail, "AttributeForSchema", columnContext);
                this.handlerHelper.addContextForRelationships(userId, schemaType, "AssetSchemaType", columnContext);
                context.put(AssetLineageEventType.COLUMN_CONTEXT_EVENT.getEventTypeName(), new RelationshipsContext(entityDetail.getGUID(), columnContext));
                break;
            }
            case "RelationalColumn": {
                this.handlerHelper.addContextForRelationships(userId, entityDetail, "NestedSchemaAttribute", columnContext);
                context.put(AssetLineageEventType.COLUMN_CONTEXT_EVENT.getEventTypeName(), new RelationshipsContext(entityDetail.getGUID(), columnContext));
            }
        }
        return context;
    }

    public RelationshipsContext buildAssetContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName;
        String methodName = "buildAssetContext";
        this.handlerHelper.validateAsset(entityDetail, "buildAssetContext", this.supportedZones);
        RelationshipsContext context = new RelationshipsContext();
        switch (typeDefName = entityDetail.getType().getTypeDefName()) {
            case "AvroFile": 
            case "CSVFile": 
            case "JSONFile": 
            case "KeystoreFile": 
            case "LogFile": 
            case "MediaFile": 
            case "Document": 
            case "DataFile": {
                context = this.buildDataFileContext(userId, entityDetail);
                break;
            }
            case "RelationalTable": {
                context = this.buildRelationalTableContext(userId, entityDetail);
            }
        }
        return context;
    }

    private boolean isInternalTabularColumn(String userId, EntityDetail tabularColumn) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "isInternalTabularColumn";
        InstancePropertyValue anchorGUIDProperty = tabularColumn.getProperties().getPropertyValue("anchorGUID");
        if (anchorGUIDProperty == null) {
            return false;
        }
        String anchorGUID = anchorGUIDProperty.valueAsString();
        if (StringUtils.isEmpty((CharSequence)anchorGUID)) {
            return false;
        }
        return this.repositoryHandler.isEntityATypeOf(userId, anchorGUID, "anchorGUID", "Process", methodName);
    }

    private RelationshipsContext buildRelationalTableContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> context = new HashSet<GraphContext>();
        EntityDetail schemaType = this.handlerHelper.addContextForRelationships(userId, entityDetail, "AttributeForSchema", context);
        EntityDetail deployedSchemaType = this.handlerHelper.addContextForRelationships(userId, schemaType, "AssetSchemaType", context);
        EntityDetail database = this.handlerHelper.addContextForRelationships(userId, deployedSchemaType, "DataContentForDataSet", context);
        if (database != null) {
            this.addConnectionToAssetContext(userId, database, context);
        }
        return new RelationshipsContext(entityDetail.getGUID(), context);
    }

    private void addConnectionToAssetContext(String userId, EntityDetail entityDetail, Set<GraphContext> context) throws OCFCheckedExceptionBase {
        EntityDetail connection = this.handlerHelper.addContextForRelationships(userId, entityDetail, "ConnectionToAsset", context);
        this.handlerHelper.addContextForRelationships(userId, connection, "ConnectionEndpoint", context);
    }

    private RelationshipsContext buildDataFileContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> context = new HashSet<GraphContext>();
        this.addConnectionToAssetContext(userId, entityDetail, context);
        EntityDetail fileFolder = this.handlerHelper.addContextForRelationships(userId, entityDetail, "NestedFile", context);
        this.addContextForFileFolder(userId, fileFolder, context);
        return new RelationshipsContext(entityDetail.getGUID(), context);
    }

    private void addContextForFileFolder(String userId, EntityDetail entityDetail, Set<GraphContext> context) throws OCFCheckedExceptionBase {
        if (entityDetail == null) {
            return;
        }
        EntityDetail fileFolder = this.handlerHelper.addContextForRelationships(userId, entityDetail, "FolderHierarchy", context);
        if (fileFolder != null) {
            this.addContextForFileFolder(userId, fileFolder, context);
        } else {
            this.addConnectionToAssetContext(userId, entityDetail, context);
        }
    }
}

