/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.exception.AssetLineageException;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContextHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessContextHandler.class);
    private final AssetContextHandler assetContextHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final List<String> supportedZones;
    private final HandlerHelper handlerHelper;

    public ProcessContextHandler(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, AssetContextHandler assetContextHandler, List<String> supportedZones, Set<String> lineageClassificationTypes) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.handlerHelper = new HandlerHelper(invalidParameterHandler, repositoryHelper, repositoryHandler, lineageClassificationTypes);
        this.assetContextHandler = assetContextHandler;
        this.supportedZones = supportedZones;
    }

    public Multimap<String, RelationshipsContext> buildProcessContext(String userId, EntityDetail process) throws OCFCheckedExceptionBase {
        String methodName = "buildProcessContext";
        String processGUID = process.getGUID();
        this.invalidParameterHandler.validateAssetInSupportedZone(processGUID, "guid", this.handlerHelper.getAssetZoneMembership(process.getClassifications()), this.supportedZones, "AssetLineageOmas", "buildProcessContext");
        List<Relationship> processPorts = this.handlerHelper.getRelationshipsByType(userId, processGUID, "ProcessPort", "Process");
        if (CollectionUtils.isEmpty(processPorts)) {
            log.error("No relationships Process Port has been found for the entity with guid {}", (Object)processGUID);
            throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getMessageDefinition(), this.getClass().getName(), "Retrieving Relationship");
        }
        RelationshipsContext relationshipsContext = this.handlerHelper.buildContextForRelationships(userId, processGUID, processPorts);
        for (Relationship processPort : processPorts) {
            EntityDetail port = this.handlerHelper.getEntityAtTheEnd(userId, processGUID, processPort);
            this.addContextForPort(userId, port, relationshipsContext.getRelationships());
        }
        ArrayListMultimap context = ArrayListMultimap.create();
        context.put((Object)AssetLineageEventType.PROCESS_CONTEXT_EVENT.getEventTypeName(), (Object)relationshipsContext);
        List<Relationship> collection = this.handlerHelper.getRelationshipsByType(userId, processGUID, "CollectionMembership", "Process");
        if (!CollectionUtils.isEmpty(collection)) {
            RelationshipsContext collectionMembershipContext = this.handlerHelper.buildContextForRelationships(userId, processGUID, collection);
            for (Relationship collectionMembership : collection) {
                EntityDetail collectionEntity = this.handlerHelper.getEntityAtTheEnd(userId, processGUID, collectionMembership);
                this.handlerHelper.addContextForRelationships(userId, collectionEntity, "CollectionMembership", collectionMembershipContext.getRelationships());
            }
            context.put((Object)AssetLineageEventType.PROCESS_CONTEXT_EVENT.getEventTypeName(), (Object)collectionMembershipContext);
        }
        Set tabularColumns = relationshipsContext.getRelationships().stream().filter(relationship -> relationship.getRelationshipType().equalsIgnoreCase("AttributeForSchema")).map(GraphContext::getToVertex).collect(Collectors.toSet());
        for (LineageEntity tabularColumn : tabularColumns) {
            this.addLineageContextForColumn(userId, (Multimap<String, RelationshipsContext>)context, tabularColumn.getGuid(), tabularColumn.getTypeDefName());
        }
        return context;
    }

    private void addLineageContextForColumn(String userId, Multimap<String, RelationshipsContext> context, String columnGUID, String typeDefName) throws OCFCheckedExceptionBase {
        List<Relationship> lineageMappings = this.handlerHelper.getRelationshipsByType(userId, columnGUID, "LineageMapping", typeDefName);
        context.put((Object)AssetLineageEventType.LINEAGE_MAPPINGS_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForRelationships(userId, columnGUID, lineageMappings));
        for (Relationship lineageMapping : lineageMappings) {
            context.putAll((Multimap)Multimaps.forMap(this.assetContextHandler.buildSchemaElementContext(userId, this.handlerHelper.getEntityAtTheEnd(userId, columnGUID, lineageMapping))));
        }
    }

    private void addContextForPort(String userId, EntityDetail port, Set<GraphContext> relationshipsContext) throws OCFCheckedExceptionBase {
        EntityDetail tabularSchemaType;
        EntityDetail tabularColumn;
        String portType = port.getType().getTypeDefName();
        if ("PortAlias".equals(portType)) {
            this.handlerHelper.addContextForRelationships(userId, port, "PortDelegation", relationshipsContext);
        }
        if ("PortImplementation".equals(portType) && (tabularColumn = this.handlerHelper.addContextForRelationships(userId, tabularSchemaType = this.handlerHelper.addContextForRelationships(userId, port, "PortSchema", relationshipsContext), "AttributeForSchema", relationshipsContext)) == null) {
            log.error("No entity TabularColumn has been found for the the TabularSchemaType with guid {}", (Object)tabularSchemaType.getGUID());
            throw new AssetLineageException(AssetLineageErrorCode.RELATIONSHIP_NOT_FOUND.getMessageDefinition(), this.getClass().getName(), "Retrieving Relationship");
        }
    }
}

