/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class Converter {
    OMRSRepositoryHelper repositoryHelper;

    public Converter(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public LineageEntity createLineageEntity(EntityDetail entityDetail) {
        LineageEntity lineageEntity = new LineageEntity();
        this.setInstanceHeaderProperties((InstanceHeader)entityDetail, lineageEntity);
        lineageEntity.setProperties(this.instancePropertiesToMap(entityDetail.getProperties()));
        return lineageEntity;
    }

    public LineageEntity createLineageEntityFromProxy(EntityProxy entityProxy) {
        return this.getLineageEntityFromLineageProxy(entityProxy);
    }

    public LineageRelationship createLineageRelationship(Relationship relationship) {
        LineageRelationship lineageRelationship = new LineageRelationship();
        this.setInstanceHeaderProperties((InstanceHeader)relationship, (LineageEntity)lineageRelationship);
        lineageRelationship.setProperties(this.instancePropertiesToMap(relationship.getProperties()));
        LineageEntity firstEntity = this.getLineageEntityFromLineageProxy(relationship.getEntityOneProxy());
        LineageEntity secondEntity = this.getLineageEntityFromLineageProxy(relationship.getEntityTwoProxy());
        lineageRelationship.setSourceEntity(firstEntity);
        lineageRelationship.setTargetEntity(secondEntity);
        return lineageRelationship;
    }

    public Map<String, String> instancePropertiesToMap(InstanceProperties properties) {
        Map instancePropertiesAsMap = this.repositoryHelper.getInstancePropertiesAsMap(properties);
        HashMap<String, String> attributes = new HashMap<String, String>();
        String methodName = "instancePropertiesToMap";
        if (MapUtils.isNotEmpty((Map)instancePropertiesAsMap)) {
            instancePropertiesAsMap.forEach((key, value) -> {
                if (value instanceof ArrayPropertyValue) {
                    List stringArrayProperty = this.repositoryHelper.getStringArrayProperty("AssetLineageOmas", key, properties, methodName);
                    attributes.put((String)key, this.listToString(stringArrayProperty));
                } else if (value instanceof MapPropertyValue) {
                    Map mapProperty = this.repositoryHelper.getMapFromProperty("AssetLineageOmas", key, properties, methodName);
                    attributes.put((String)key, this.mapToString(mapProperty));
                } else {
                    if (key.equals("name")) {
                        key = "displayName";
                    }
                    attributes.put((String)key, String.valueOf(value));
                }
            });
        }
        return attributes;
    }

    private void setInstanceHeaderProperties(InstanceHeader instanceHeader, LineageEntity lineageEntity) {
        lineageEntity.setGuid(instanceHeader.getGUID());
        lineageEntity.setCreatedBy(instanceHeader.getCreatedBy());
        lineageEntity.setCreateTime(instanceHeader.getCreateTime());
        lineageEntity.setTypeDefName(instanceHeader.getType().getTypeDefName());
        lineageEntity.setUpdatedBy(instanceHeader.getUpdatedBy());
        lineageEntity.setUpdateTime(instanceHeader.getUpdateTime());
        lineageEntity.setVersion(instanceHeader.getVersion());
        lineageEntity.setMetadataCollectionId(instanceHeader.getMetadataCollectionId());
    }

    private LineageEntity getLineageEntityFromLineageProxy(EntityProxy entityProxy) {
        LineageEntity entity = new LineageEntity();
        entity.setGuid(entityProxy.getGUID());
        entity.setVersion(entityProxy.getVersion());
        entity.setCreatedBy(entityProxy.getCreatedBy());
        entity.setUpdatedBy(entityProxy.getUpdatedBy());
        entity.setCreateTime(entityProxy.getCreateTime());
        entity.setUpdateTime(entityProxy.getUpdateTime());
        entity.setTypeDefName(entityProxy.getType().getTypeDefName());
        entity.setProperties(this.instancePropertiesToMap(entityProxy.getUniqueProperties()));
        return entity;
    }

    private String listToString(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return String.join((CharSequence)",", list);
    }

    private String mapToString(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        return map.keySet().stream().map(key -> key + ": " + map.get(key)).collect(Collectors.joining(", "));
    }
}

