/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.outtopic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipsEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageSyncEvent;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineagePublishSummary;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageSyncUpdateContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineagePublisher {
    private static final Logger log = LoggerFactory.getLogger(AssetLineagePublisher.class);
    private static final AssetLineageInstanceHandler instanceHandler = new AssetLineageInstanceHandler();
    private final OpenMetadataTopicConnector outTopicConnector;
    private final String serverUserName;
    private final ProcessContextHandler processContextHandler;
    private final ClassificationHandler classificationHandler;
    private final GlossaryContextHandler glossaryHandler;
    private final AssetContextHandler assetContextHandler;
    private int batchSize;

    public AssetLineagePublisher(OpenMetadataTopicConnector outTopicConnector, String serverName, String serverUserName, int batchSize) throws OCFCheckedExceptionBase {
        String methodName = "AssetLineagePublisher";
        this.outTopicConnector = outTopicConnector;
        this.serverUserName = serverUserName;
        this.batchSize = batchSize;
        this.processContextHandler = instanceHandler.getProcessHandler(serverUserName, serverName, methodName);
        this.classificationHandler = instanceHandler.getClassificationHandler(serverUserName, serverName, methodName);
        this.glossaryHandler = instanceHandler.getGlossaryHandler(serverUserName, serverName, methodName);
        this.assetContextHandler = instanceHandler.getAssetContextHandler(serverUserName, serverName, methodName);
    }

    public Multimap<String, RelationshipsContext> publishProcessContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Multimap<String, RelationshipsContext> processContext = this.processContextHandler.buildProcessContext(this.serverUserName, entityDetail);
        this.publishLineageRelationshipsEvents(processContext);
        return processContext;
    }

    public void publishGlossaryContext(String glossaryTermGUID) throws OCFCheckedExceptionBase, JsonProcessingException {
        EntityDetail entityDetail = this.glossaryHandler.getGlossaryTermDetails(this.serverUserName, glossaryTermGUID);
        this.publishGlossaryContext(entityDetail);
    }

    public Multimap<String, RelationshipsContext> publishGlossaryContext(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        Multimap<String, RelationshipsContext> glossaryTermContext = this.glossaryHandler.buildGlossaryTermContext(this.serverUserName, entityDetail);
        if (glossaryTermContext.isEmpty()) {
            log.info("Context not found for the entity {} ", (Object)entityDetail.getGUID());
        }
        this.publishGlossaryTermLineageRelationshipsEvents(glossaryTermContext);
        this.publishLineageSyncUpdateEvent(entityDetail.getGUID(), glossaryTermContext);
        return glossaryTermContext;
    }

    private void publishLineageRelationshipsEvents(Multimap<String, RelationshipsContext> contextMap) throws JsonProcessingException, ConnectorCheckedException {
        for (String eventType : contextMap.keySet()) {
            for (RelationshipsContext relationshipsContext : contextMap.get((Object)eventType)) {
                if (!CollectionUtils.isNotEmpty((Collection)relationshipsContext.getRelationships())) continue;
                LineageRelationshipsEvent event = new LineageRelationshipsEvent();
                event.setRelationshipsContext(relationshipsContext);
                event.setAssetLineageEventType(AssetLineageEventType.getByEventTypeName((String)eventType));
                this.publishEvent((AssetLineageEventHeader)event);
            }
        }
    }

    private void publishGlossaryTermLineageRelationshipsEvents(Multimap<String, RelationshipsContext> contextMap) throws JsonProcessingException, ConnectorCheckedException {
        for (String eventType : contextMap.keySet()) {
            for (RelationshipsContext relationshipsContext : contextMap.get((Object)eventType)) {
                if (!CollectionUtils.isNotEmpty((Collection)relationshipsContext.getRelationships())) continue;
                int noOfRelationships = relationshipsContext.getRelationships().size();
                int batchNumber = noOfRelationships / this.batchSize + 1;
                Iterator relationshipsIterator = relationshipsContext.getRelationships().iterator();
                for (int i = 0; i < batchNumber; ++i) {
                    HashSet<GraphContext> batch = new HashSet<GraphContext>();
                    for (int j = 0; j < this.batchSize && relationshipsIterator.hasNext(); ++j) {
                        batch.add((GraphContext)relationshipsIterator.next());
                    }
                    RelationshipsContext relationshipContextChunk = new RelationshipsContext();
                    relationshipContextChunk.setRelationships(batch);
                    relationshipContextChunk.setEntityGuid(relationshipsContext.getEntityGuid());
                    LineageRelationshipsEvent event = new LineageRelationshipsEvent();
                    event.setRelationshipsContext(relationshipContextChunk);
                    event.setAssetLineageEventType(AssetLineageEventType.getByEventTypeName((String)eventType));
                    this.publishEvent((AssetLineageEventHeader)event);
                }
            }
        }
    }

    private void publishLineageSyncUpdateEvent(String entityGUID, Multimap<String, RelationshipsContext> contextMap) throws JsonProcessingException, ConnectorCheckedException {
        HashSet neighbourGuids = new HashSet();
        for (String eventType : contextMap.keySet()) {
            for (RelationshipsContext relationshipsContext : contextMap.get((Object)eventType)) {
                List fromVertexGuids = relationshipsContext.getRelationships().stream().map(r -> r.getFromVertex().getGuid()).filter(str -> !str.equals(entityGUID)).collect(Collectors.toList());
                List toVertexGuids = relationshipsContext.getRelationships().stream().map(r -> r.getToVertex().getGuid()).filter(str -> !str.equals(entityGUID)).collect(Collectors.toList());
                neighbourGuids.addAll(fromVertexGuids);
                neighbourGuids.addAll(toVertexGuids);
            }
        }
        LineageSyncUpdateContext lineageSyncUpdateContext = new LineageSyncUpdateContext();
        lineageSyncUpdateContext.setEntityGUID(entityGUID);
        lineageSyncUpdateContext.setNeighboursGUID(neighbourGuids);
        LineageSyncEvent event = new LineageSyncEvent();
        event.setSyncUpdateContext(lineageSyncUpdateContext);
        event.setAssetLineageEventType(AssetLineageEventType.LINEAGE_SYNC_EVENT);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishClassificationContext(EntityDetail entityDetail, AssetLineageEventType assetLineageEventType) throws OCFCheckedExceptionBase, JsonProcessingException {
        Map<String, RelationshipsContext> classificationContext = this.classificationHandler.buildClassificationContext(entityDetail, assetLineageEventType);
        if (MapUtils.isEmpty(classificationContext)) {
            log.debug("Lineage classifications not found for the entity {} ", (Object)entityDetail.getGUID());
            return;
        }
        this.publishLineageRelationshipsEvents((Multimap<String, RelationshipsContext>)Multimaps.forMap(classificationContext));
    }

    public void publishLineageRelationshipEvent(LineageRelationship lineageRelationship, AssetLineageEventType eventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageRelationshipEvent event = new LineageRelationshipEvent();
        event.setLineageRelationship(lineageRelationship);
        event.setAssetLineageEventType(eventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishAssetContextEvent(RelationshipsContext assetContext) throws ConnectorCheckedException, JsonProcessingException {
        LineageRelationshipsEvent event = new LineageRelationshipsEvent();
        event.setRelationshipsContext(assetContext);
        event.setAssetLineageEventType(AssetLineageEventType.ASSET_CONTEXT_EVENT);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishEvent(AssetLineageEventHeader event) throws JsonProcessingException, ConnectorCheckedException {
        if (this.outTopicConnector == null) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        this.outTopicConnector.sendEvent(objectMapper.writeValueAsString((Object)event));
    }

    public void publishLineageSummaryEvent(LineagePublishSummary summary) throws JsonProcessingException, ConnectorCheckedException {
        LineageSyncEvent event = new LineageSyncEvent();
        event.setPublishSummary(summary);
        event.setAssetLineageEventType(AssetLineageEventType.LINEAGE_SYNC_EVENT);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishLineageEntityEvent(LineageEntity lineageEntity, AssetLineageEventType lineageEventType) throws ConnectorCheckedException, JsonProcessingException {
        LineageEntityEvent event = new LineageEntityEvent();
        event.setLineageEntity(lineageEntity);
        event.setAssetLineageEventType(lineageEventType);
        this.publishEvent((AssetLineageEventHeader)event);
    }

    public void publishLineageMappingRelationshipEvent(LineageRelationship lineageRelationship, AssetLineageEventType eventType) throws OCFCheckedExceptionBase, JsonProcessingException {
        this.publishLineageRelationshipEvent(lineageRelationship, eventType);
        this.publishLineageMappingContext(lineageRelationship.getSourceEntity());
        this.publishLineageMappingContext(lineageRelationship.getTargetEntity());
    }

    private void publishLineageMappingContext(LineageEntity lineageEntity) throws JsonProcessingException, OCFCheckedExceptionBase {
        this.publishLineageRelationshipsEvents((Multimap<String, RelationshipsContext>)Multimaps.forMap(this.assetContextHandler.buildColumnContext(this.serverUserName, lineageEntity)));
        this.publishLineageRelationshipsEvents((Multimap<String, RelationshipsContext>)Multimaps.forMap(this.assetContextHandler.buildAssetContext(this.serverUserName, lineageEntity)));
        Optional<LineageEntity> entityContext = this.assetContextHandler.buildEntityContext(this.serverUserName, lineageEntity.getGuid(), lineageEntity.getTypeDefName());
        if (entityContext.isPresent()) {
            this.publishLineageEntityEvent(entityContext.get(), AssetLineageEventType.UPDATE_ENTITY_EVENT);
        }
        log.debug("Asset Lineage OMAS published the context for entity with guid {} and type {}", (Object)lineageEntity.getGuid(), (Object)lineageEntity.getTypeDefName());
    }

    public boolean isEntityEligibleForPublishing(EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        if (typeDefName.equals("GlossaryCategory") || typeDefName.equals("GlossaryTerm")) {
            return this.glossaryHandler.hasGlossaryTermLineageRelationships(this.serverUserName, entityDetail);
        }
        return true;
    }
}

