/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.GenericStub;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class AssetContextHandler {
    private final OpenMetadataAPIGenericHandler<GenericStub> genericHandler;
    private final HandlerHelper handlerHelper;
    private final List<String> supportedZones;

    public AssetContextHandler(OpenMetadataAPIGenericHandler<GenericStub> genericHandler, HandlerHelper handlerHelper, List<String> supportedZones) {
        this.genericHandler = genericHandler;
        this.handlerHelper = handlerHelper;
        this.supportedZones = supportedZones;
    }

    public Map<String, RelationshipsContext> buildSchemaElementContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String methodName = "buildSchemaElementContext";
        this.handlerHelper.validateAsset(entityDetail, "buildSchemaElementContext", this.supportedZones);
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        String typeDefName = entityDetail.getType().getTypeDefName();
        Set<Object> columnContext = new HashSet();
        switch (typeDefName) {
            case "TabularColumn": {
                if (this.isInternalTabularColumn(userId, entityDetail)) break;
                columnContext = this.buildTabularColumnContext(userId, entityDetail);
                break;
            }
            case "TabularFileColumn": {
                columnContext = this.buildTabularColumnContext(userId, entityDetail);
                break;
            }
            case "RelationalColumn": {
                columnContext = this.buildRelationalColumnContext(userId, entityDetail);
                break;
            }
            case "EventSchemaAttribute": {
                columnContext = this.buildEventSchemaAttributeContext(userId, entityDetail);
                break;
            }
            default: {
                return context;
            }
        }
        context.put(AssetLineageEventType.COLUMN_CONTEXT_EVENT.getEventTypeName(), new RelationshipsContext(entityDetail.getGUID(), columnContext));
        return context;
    }

    public Map<String, RelationshipsContext> buildAssetContext(String userId, LineageEntity lineageEntity) throws OCFCheckedExceptionBase {
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        EntityDetail asset = this.handlerHelper.getEntityDetails(userId, lineageEntity.getGuid(), lineageEntity.getTypeDefName());
        context.put(AssetLineageEventType.ASSET_CONTEXT_EVENT.getEventTypeName(), this.buildAssetContext(userId, asset));
        return context;
    }

    public RelationshipsContext buildAssetContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String methodName = "buildAssetContext";
        this.handlerHelper.validateAsset(entityDetail, "buildAssetContext", this.supportedZones);
        RelationshipsContext context = new RelationshipsContext();
        if (this.handlerHelper.isDataStore(userId, entityDetail)) {
            context = this.buildDataFileContext(userId, entityDetail);
        }
        if (this.handlerHelper.isTable(userId, entityDetail)) {
            context = this.buildRelationalTableContext(userId, entityDetail);
        }
        if (this.handlerHelper.isTopic(userId, entityDetail)) {
            context = this.buildTopicContext(userId, entityDetail);
        }
        return context;
    }

    public Map<String, RelationshipsContext> buildColumnContext(String userId, LineageEntity lineageEntity) throws OCFCheckedExceptionBase {
        if (!this.handlerHelper.isSchemaAttribute(userId, lineageEntity.getTypeDefName())) {
            return new HashMap<String, RelationshipsContext>();
        }
        EntityDetail entityDetail = this.handlerHelper.getEntityDetails(userId, lineageEntity.getGuid(), "SchemaAttribute");
        return this.buildSchemaElementContext(userId, entityDetail);
    }

    public Optional<LineageEntity> buildEntityContext(String userId, String guid, String typeDefName) throws OCFCheckedExceptionBase {
        EntityDetail entityDetail = this.handlerHelper.getEntityDetails(userId, guid, typeDefName);
        return Optional.of(this.handlerHelper.getLineageEntity(entityDetail));
    }

    private boolean isInternalTabularColumn(String userId, EntityDetail tabularColumn) throws OCFCheckedExceptionBase {
        String methodName = "isInternalTabularColumn";
        Optional<Relationship> relationship = this.handlerHelper.getUniqueRelationshipByType(userId, tabularColumn.getGUID(), "AttributeForSchema", tabularColumn.getType().getTypeDefName());
        if (relationship.isEmpty()) {
            return false;
        }
        EntityDetail schemaType = this.handlerHelper.getEntityAtTheEnd(userId, tabularColumn.getGUID(), relationship.get());
        Optional<Classification> anchorGUIDClassification = this.getAnchorsClassification(schemaType);
        if (anchorGUIDClassification.isEmpty()) {
            return false;
        }
        Optional<String> anchorGUID = this.getAnchorGUID(anchorGUIDClassification.get());
        if (anchorGUID.isEmpty()) {
            return false;
        }
        return this.genericHandler.isEntityATypeOf(userId, anchorGUID.get(), "anchorGUID", "PortImplementation", true, false, null, methodName);
    }

    private Optional<String> getAnchorGUID(Classification classification) {
        InstancePropertyValue anchorGUIDProperty = classification.getProperties().getPropertyValue("anchorGUID");
        if (anchorGUIDProperty == null) {
            return Optional.empty();
        }
        return Optional.of(anchorGUIDProperty.valueAsString());
    }

    private Optional<Classification> getAnchorsClassification(EntityDetail entityDetail) {
        List classifications = entityDetail.getClassifications();
        if (CollectionUtils.isEmpty((Collection)classifications)) {
            return Optional.empty();
        }
        for (Classification classification : classifications) {
            if (!"Anchors".equalsIgnoreCase(classification.getName())) continue;
            return Optional.of(classification);
        }
        return Optional.empty();
    }

    private RelationshipsContext buildRelationalTableContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> context = new HashSet<GraphContext>();
        EntityDetail schemaType = this.handlerHelper.addContextForRelationships(userId, entityDetail, "AttributeForSchema", context);
        EntityDetail deployedSchemaType = this.handlerHelper.addContextForRelationships(userId, schemaType, "AssetSchemaType", context);
        EntityDetail database = this.handlerHelper.addContextForRelationships(userId, deployedSchemaType, "DataContentForDataSet", context);
        if (database != null) {
            this.addConnectionToAssetContext(userId, database, context);
        }
        return new RelationshipsContext(entityDetail.getGUID(), context);
    }

    private void addConnectionToAssetContext(String userId, EntityDetail entityDetail, Set<GraphContext> context) throws OCFCheckedExceptionBase {
        EntityDetail connection = this.handlerHelper.addContextForRelationships(userId, entityDetail, "ConnectionToAsset", context);
        this.handlerHelper.addContextForRelationships(userId, connection, "ConnectionEndpoint", context);
    }

    private RelationshipsContext buildDataFileContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> context = new HashSet<GraphContext>();
        this.addConnectionToAssetContext(userId, entityDetail, context);
        EntityDetail fileFolder = this.handlerHelper.addContextForRelationships(userId, entityDetail, "NestedFile", context);
        this.addContextForFileFolder(userId, fileFolder, context);
        return new RelationshipsContext(entityDetail.getGUID(), context);
    }

    private void addContextForFileFolder(String userId, EntityDetail entityDetail, Set<GraphContext> context) throws OCFCheckedExceptionBase {
        if (entityDetail == null) {
            return;
        }
        EntityDetail fileFolder = this.handlerHelper.addContextForRelationships(userId, entityDetail, "FolderHierarchy", context);
        if (fileFolder != null) {
            this.addContextForFileFolder(userId, fileFolder, context);
        } else {
            this.addConnectionToAssetContext(userId, entityDetail, context);
        }
    }

    private Set<GraphContext> buildRelationalColumnContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> columnContext = new HashSet<GraphContext>();
        this.handlerHelper.addContextForRelationships(userId, entityDetail, "NestedSchemaAttribute", columnContext);
        return columnContext;
    }

    private Set<GraphContext> buildTabularColumnContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> columnContext = new HashSet<GraphContext>();
        EntityDetail schemaType = this.handlerHelper.addContextForRelationships(userId, entityDetail, "AttributeForSchema", columnContext);
        this.handlerHelper.addContextForRelationships(userId, schemaType, "AssetSchemaType", columnContext);
        return columnContext;
    }

    private RelationshipsContext buildTopicContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> context = new HashSet<GraphContext>();
        this.handlerHelper.addContextForRelationships(userId, entityDetail, "AssetSchemaType", context);
        return new RelationshipsContext(entityDetail.getGUID(), context);
    }

    private Set<GraphContext> buildEventSchemaAttributeContext(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        HashSet<GraphContext> columnContext = new HashSet<GraphContext>();
        EntityDetail eventType = this.handlerHelper.addContextForRelationships(userId, entityDetail, "AttributeForSchema", columnContext);
        EntityDetail eventTypeList = this.handlerHelper.addContextForRelationships(userId, eventType, "SchemaTypeOption", columnContext);
        this.handlerHelper.addContextForRelationships(userId, eventTypeList, "AssetSchemaType", columnContext);
        return columnContext;
    }
}

