/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.model.FindEntitiesParameters;
import org.odpi.openmetadata.accessservices.assetlineage.model.GenericStub;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageTypesValidator;
import org.odpi.openmetadata.accessservices.assetlineage.util.ClockService;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class HandlerHelper {
    private static final String GUID_PARAMETER = "guid";
    private final OpenMetadataAPIGenericHandler<GenericStub> genericHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final Converter converter;
    private final AssetLineageTypesValidator assetLineageTypesValidator;
    private final ClockService clockService;

    public HandlerHelper(InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, OpenMetadataAPIGenericHandler<GenericStub> genericHandler, Converter converter, AssetLineageTypesValidator assetLineageTypesValidator, ClockService clockService) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.genericHandler = genericHandler;
        this.assetLineageTypesValidator = assetLineageTypesValidator;
        this.converter = converter;
        this.clockService = clockService;
    }

    List<Relationship> getRelationshipsByType(String userId, String entityGUID, String relationshipTypeName, String entityTypeName) throws OCFCheckedExceptionBase {
        String methodName = "getRelationshipsByType";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipsByType");
        this.invalidParameterHandler.validateGUID(entityGUID, GUID_PARAMETER, "getRelationshipsByType");
        String relationshipTypeGUID = this.getTypeGUID(userId, relationshipTypeName);
        List relationships = this.genericHandler.getAttachmentLinks(userId, entityGUID, GUID_PARAMETER, entityTypeName, relationshipTypeGUID, relationshipTypeName, null, null, 0, true, false, 0, 0, this.clockService.getNow(), "getRelationshipsByType");
        if (CollectionUtils.isEmpty((Collection)relationships)) {
            return Collections.emptyList();
        }
        return relationships.stream().filter(relationship -> relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null).collect(Collectors.toList());
    }

    Optional<Relationship> getUniqueRelationshipByType(String userId, String entityGUID, String relationshipTypeName, String entityTypeName) throws OCFCheckedExceptionBase {
        String methodName = "getUniqueRelationshipsByType";
        this.invalidParameterHandler.validateUserId(userId, "getUniqueRelationshipsByType");
        this.invalidParameterHandler.validateGUID(entityGUID, GUID_PARAMETER, "getUniqueRelationshipsByType");
        String relationshipTypeGuid = this.getTypeGUID(userId, relationshipTypeName);
        return Optional.ofNullable(this.genericHandler.getUniqueAttachmentLink(userId, entityGUID, GUID_PARAMETER, entityTypeName, relationshipTypeGuid, relationshipTypeName, null, null, 0, true, false, this.clockService.getNow(), "getUniqueRelationshipsByType"));
    }

    String getTypeGUID(String userId, String typeDefName) {
        TypeDef typeDefByName = this.repositoryHelper.getTypeDefByName(userId, typeDefName);
        if (typeDefByName != null) {
            return typeDefByName.getGUID();
        }
        return null;
    }

    EntityDetail getEntityAtTheEnd(String userId, String entityDetailGUID, Relationship relationship) throws OCFCheckedExceptionBase {
        String methodName = "getEntityAtTheEnd";
        if (relationship.getEntityOneProxy().getGUID().equals(entityDetailGUID)) {
            return this.genericHandler.getEntityFromRepository(userId, relationship.getEntityTwoProxy().getGUID(), GUID_PARAMETER, relationship.getEntityTwoProxy().getType().getTypeDefName(), null, null, true, false, this.clockService.getNow(), methodName);
        }
        if (relationship.getEntityTwoProxy().getGUID().equals(entityDetailGUID)) {
            return this.genericHandler.getEntityFromRepository(userId, relationship.getEntityOneProxy().getGUID(), GUID_PARAMETER, relationship.getEntityOneProxy().getType().getTypeDefName(), null, null, true, false, this.clockService.getNow(), methodName);
        }
        return null;
    }

    public EntityDetail getEntityDetails(String userId, String entityDetailGUID, String entityTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEntityDetails";
        return this.genericHandler.getEntityFromRepository(userId, entityDetailGUID, GUID_PARAMETER, entityTypeName, null, null, true, false, this.clockService.getNow(), methodName);
    }

    public Optional<List<EntityDetail>> findEntitiesByType(String userId, String entityTypeName, SearchProperties searchProperties, FindEntitiesParameters findEntitiesParameters) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        ArrayList<EntityDetail> allEntities = new ArrayList<EntityDetail>();
        int startingFrom = 0;
        int pageSize = this.invalidParameterHandler.getMaxPagingSize();
        while (this.addPagedEntities(userId, entityTypeName, searchProperties, findEntitiesParameters, allEntities, startingFrom, pageSize)) {
            startingFrom += pageSize;
        }
        return Optional.of(allEntities);
    }

    private boolean addPagedEntities(String userId, String entityTypeName, SearchProperties searchProperties, FindEntitiesParameters findEntitiesParameters, List<EntityDetail> allEntities, int startingFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addPagedEntities";
        String typeDefGUID = this.getTypeGUID(userId, entityTypeName);
        List pagedEntities = this.genericHandler.findEntities(userId, typeDefGUID, findEntitiesParameters.getEntitySubtypeGUIDs(), searchProperties, findEntitiesParameters.getLimitResultsByStatus(), findEntitiesParameters.getSearchClassifications(), null, findEntitiesParameters.getSequencingProperty(), findEntitiesParameters.getSequencingOrder(), true, false, startingFrom, pageSize, this.clockService.getNow(), "addPagedEntities");
        if (pagedEntities == null) {
            return false;
        }
        allEntities.addAll(pagedEntities);
        return pagedEntities.size() == pageSize;
    }

    List<String> getAssetZoneMembership(List<Classification> classifications) {
        List zoneMembership;
        String methodName = "getAssetZoneMembership";
        if (CollectionUtils.isEmpty(classifications)) {
            return Collections.emptyList();
        }
        Optional<Classification> assetZoneMembership = classifications.stream().filter(classification -> classification.getName().equals("AssetZoneMembership")).findFirst();
        if (assetZoneMembership.isPresent() && CollectionUtils.isNotEmpty((Collection)(zoneMembership = this.repositoryHelper.getStringArrayProperty("AssetLineageOmas", "zoneMembership", assetZoneMembership.get().getProperties(), methodName)))) {
            return zoneMembership;
        }
        return Collections.emptyList();
    }

    private LineageEntity getClassificationVertex(Classification classification, String entityGUID) {
        LineageEntity classificationVertex = new LineageEntity();
        String classificationGUID = classification.getName() + entityGUID;
        classificationVertex.setGuid(classificationGUID);
        this.copyClassificationProperties(classificationVertex, classification);
        return classificationVertex;
    }

    private void copyClassificationProperties(LineageEntity lineageEntity, Classification classification) {
        lineageEntity.setVersion(classification.getVersion());
        lineageEntity.setTypeDefName(classification.getType().getTypeDefName());
        lineageEntity.setCreatedBy(classification.getCreatedBy());
        lineageEntity.setUpdatedBy(classification.getUpdatedBy());
        lineageEntity.setCreateTime(classification.getCreateTime());
        lineageEntity.setUpdateTime(classification.getUpdateTime());
        lineageEntity.setProperties(this.converter.instancePropertiesToMap(classification.getProperties()));
    }

    public SearchProperties getSearchPropertiesAfterUpdateTime(Long time) {
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        primitivePropertyValue.setPrimitiveValue((Object)time);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
        PropertyCondition propertyCondition = new PropertyCondition();
        propertyCondition.setProperty("updateTime");
        propertyCondition.setOperator(PropertyComparisonOperator.GT);
        propertyCondition.setValue((InstancePropertyValue)primitivePropertyValue);
        SearchProperties searchProperties = new SearchProperties();
        searchProperties.setConditions(Collections.singletonList(propertyCondition));
        return searchProperties;
    }

    public RelationshipsContext buildContextForRelationships(String userId, String entityGUID, List<Relationship> relationships) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        HashSet<GraphContext> lineageRelationships = new HashSet<GraphContext>();
        for (Relationship relationship : relationships) {
            EntityDetail startEntity = this.getEntityDetails(userId, relationship.getEntityOneProxy().getGUID(), relationship.getEntityOneProxy().getType().getTypeDefName());
            EntityDetail endEntity = this.getEntityDetails(userId, relationship.getEntityTwoProxy().getGUID(), relationship.getEntityTwoProxy().getType().getTypeDefName());
            if (endEntity == null) continue;
            LineageEntity startVertex = this.converter.createLineageEntity(startEntity);
            LineageEntity endVertex = this.converter.createLineageEntity(endEntity);
            lineageRelationships.add(new GraphContext(relationship.getType().getTypeDefName(), relationship.getGUID(), startVertex, endVertex));
        }
        return new RelationshipsContext(entityGUID, lineageRelationships);
    }

    public RelationshipsContext buildContextForLineageClassifications(EntityDetail entityDetail) {
        List<Classification> classifications = this.assetLineageTypesValidator.filterLineageClassifications(entityDetail.getClassifications());
        LineageEntity originalEntityVertex = this.converter.createLineageEntity(entityDetail);
        String entityGUID = entityDetail.getGUID();
        return new RelationshipsContext(entityGUID, classifications.stream().map(classification -> this.getClassificationVertex((Classification)classification, entityGUID)).map(classificationVertex -> new GraphContext("Classification", classificationVertex.getGuid(), originalEntityVertex, classificationVertex)).collect(Collectors.toSet()));
    }

    protected EntityDetail addContextForRelationships(String userId, EntityDetail startEntity, String relationshipTypeName, Set<GraphContext> context) throws OCFCheckedExceptionBase {
        if (startEntity == null) {
            return null;
        }
        context.addAll(this.buildContextForLineageClassifications(startEntity).getRelationships());
        List<Object> relationships = this.getRelationshipsByType(userId, startEntity.getGUID(), relationshipTypeName, startEntity.getType().getTypeDefName());
        if (CollectionUtils.isEmpty(relationships)) {
            return null;
        }
        if (startEntity.getType().getTypeDefName().equals("FileFolder") && CollectionUtils.isEmpty(relationships = relationships.stream().filter(relationship -> relationship.getEntityTwoProxy().getGUID().equals(startEntity.getGUID())).collect(Collectors.toList()))) {
            return null;
        }
        context.addAll(this.buildContextForRelationships(userId, startEntity.getGUID(), relationships).getRelationships());
        return this.getEntityAtTheEnd(userId, startEntity.getGUID(), (Relationship)relationships.get(0));
    }

    public void validateAsset(EntityDetail entityDetail, String methodName, List<String> supportedZones) throws InvalidParameterException {
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), GUID_PARAMETER, methodName);
        this.invalidParameterHandler.validateAssetInSupportedZone(entityDetail.getGUID(), GUID_PARAMETER, this.getAssetZoneMembership(entityDetail.getClassifications()), supportedZones, "AssetLineageOmas", methodName);
    }

    public LineageEntity getLineageEntity(EntityDetail entityDetail) {
        return this.converter.createLineageEntity(entityDetail);
    }

    public boolean isDataStore(String serviceName, EntityDetail entityDetail) {
        return this.repositoryHelper.isTypeOf(serviceName, entityDetail.getType().getTypeDefName(), "DataStore");
    }

    public boolean isTable(String serviceName, EntityDetail entityDetail) {
        return this.repositoryHelper.isTypeOf(serviceName, entityDetail.getType().getTypeDefName(), "RelationalTable");
    }

    public boolean isSchemaAttribute(String serviceName, String typeName) {
        return this.repositoryHelper.isTypeOf(serviceName, typeName, "SchemaAttribute");
    }

    public boolean isTopic(String serviceName, EntityDetail entityDetail) {
        return this.repositoryHelper.isTypeOf(serviceName, entityDetail.getType().getTypeDefName(), "Topic");
    }
}

