/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;

public class ClassificationHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final HandlerHelper handlerHelper;

    public ClassificationHandler(InvalidParameterHandler invalidParameterHandler, HandlerHelper handlerHelper) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.handlerHelper = handlerHelper;
    }

    public Map<String, RelationshipsContext> buildClassificationContext(EntityDetail entityDetail, AssetLineageEventType assetLineageEventType) throws OCFCheckedExceptionBase {
        String methodName = "buildClassificationContext";
        this.invalidParameterHandler.validateGUID(entityDetail.getGUID(), "guid", methodName);
        HashMap<String, RelationshipsContext> context = new HashMap<String, RelationshipsContext>();
        context.put(assetLineageEventType.getEventTypeName(), this.handlerHelper.buildContextForLineageClassifications(entityDetail));
        return context;
    }
}

