/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.admin;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.listeners.AssetLineageOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageServicesInstance;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageTypesValidator;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageAdmin
extends AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageAdmin.class);
    private AuditLog auditLog;
    private AssetLineageServicesInstance instance;
    private String serverName;
    private final int defaultPublisherBatchSize = 1;
    private final String PUBLISHER_BATCH_SIZE_PROPERTY_NAME = "LineagePublisherBatchSize";

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", AssetLineageAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.auditLog = auditLog;
            Map accessServiceOptions = accessServiceConfigurationProperties.getAccessServiceOptions();
            List supportedZones = this.extractSupportedZones(accessServiceOptions, accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
            AssetLineageTypesValidator assetLineageTypesValidator = new AssetLineageTypesValidator(repositoryConnector.getRepositoryHelper(), accessServiceOptions);
            this.instance = new AssetLineageServicesInstance(repositoryConnector, supportedZones, serverUserName, auditLog, accessServiceConfigurationProperties.getAccessServiceOutTopic(), assetLineageTypesValidator);
            this.serverName = this.instance.getServerName();
            Connection outTopicConnection = accessServiceConfigurationProperties.getAccessServiceOutTopic();
            if (outTopicConnection != null) {
                OpenMetadataTopicConnector outTopicConnector = super.getOutTopicEventBusConnector(outTopicConnection, accessServiceConfigurationProperties.getAccessServiceName(), auditLog);
                Converter converter = new Converter(repositoryConnector.getRepositoryHelper());
                int batchSize = this.extractLineagePublisherBatchSize(accessServiceOptions, this.getFullServiceName(), auditLog);
                AssetLineagePublisher publisher = new AssetLineagePublisher(outTopicConnector, this.serverName, serverUserName, batchSize);
                AssetLineageOMRSTopicListener omrsTopicListener = new AssetLineageOMRSTopicListener(converter, this.serverName, publisher, assetLineageTypesValidator, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfigurationProperties.getAccessServiceName(), this.serverName, enterpriseOMRSTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
                this.instance.setAssetLineagePublisher(omrsTopicListener.getPublisher());
            }
            auditLog.logMessage("initialize", AssetLineageAuditCode.SERVICE_INITIALIZED.getMessageDefinition(this.serverName));
        }
        catch (Exception error) {
            log.error("The Asset Lineage OMAS could not be started", (Throwable)error);
            auditLog.logException("initialize", AssetLineageAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage(), this.serverName), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_LINEAGE_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    private int extractLineagePublisherBatchSize(Map<String, Object> accessServiceOptions, String accessServiceFullName, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractLineagePublisherBatchSize";
        if (accessServiceOptions == null) {
            return 1;
        }
        Object propertyValue = accessServiceOptions.get("LineagePublisherBatchSize");
        if (propertyValue == null) {
            return 1;
        }
        try {
            int value = Integer.parseInt(propertyValue.toString());
            auditLog.logMessage("extractLineagePublisherBatchSize", AssetLineageAuditCode.CONFIGURED_PUBLISHER_BATCH_SIZE.getMessageDefinition("LineagePublisherBatchSize", Integer.toString(value)));
            return value < 1 ? 1 : value;
        }
        catch (Exception error) {
            auditLog.logMessage("extractLineagePublisherBatchSize", AssetLineageAuditCode.INVALID_PUBLISHER_BATCH_SIZE.getMessageDefinition("LineagePublisherBatchSize"));
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{accessServiceFullName, propertyValue.toString(), "LineagePublisherBatchSize", error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "extractLineagePublisherBatchSize", (Throwable)error);
        }
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            this.auditLog.logMessage("shutdown", AssetLineageAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
        }
    }
}

