/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.handlers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.model.RelationshipsContext;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

public class GlossaryContextHandler {
    private final InvalidParameterHandler invalidParameterHandler;
    private final HandlerHelper handlerHelper;
    private final AssetContextHandler assetContextHandler;

    public GlossaryContextHandler(InvalidParameterHandler invalidParameterHandler, AssetContextHandler assetContextHandler, HandlerHelper handlerHelper) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.handlerHelper = handlerHelper;
        this.assetContextHandler = assetContextHandler;
    }

    public EntityDetail getGlossaryTermDetails(String userId, String glossaryTermGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.handlerHelper.getEntityDetails(userId, glossaryTermGUID, "GlossaryTerm");
    }

    public Multimap<String, RelationshipsContext> buildGlossaryTermContext(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        String methodName = "buildGlossaryTermContext";
        String glossaryTermGUID = glossaryTerm.getGUID();
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "guid", methodName);
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTermGUID, "GlossaryTerm");
        List<Relationship> termCategorizations = this.getTermCategorizations(userId, glossaryTermGUID, "GlossaryTerm");
        List<Relationship> glossaries = this.getTermAnchors(userId, glossaryTermGUID);
        ArrayListMultimap context = ArrayListMultimap.create();
        if (Stream.of(semanticAssignments, termCategorizations, glossaries).allMatch(CollectionUtils::isEmpty)) {
            return context;
        }
        context.put((Object)AssetLineageEventType.SEMANTIC_ASSIGNMENTS_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, semanticAssignments));
        context.put((Object)AssetLineageEventType.TERM_CATEGORIZATIONS_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, termCategorizations));
        context.put((Object)AssetLineageEventType.TERM_ANCHORS_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, glossaries));
        List<Relationship> glossariesForCategories = this.getGlossariesForCategories(userId, glossaryTermGUID, termCategorizations);
        context.put((Object)AssetLineageEventType.CATEGORY_ANCHORS_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForRelationships(userId, glossaryTermGUID, glossariesForCategories));
        context.put((Object)AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT.getEventTypeName(), (Object)this.handlerHelper.buildContextForLineageClassifications(glossaryTerm));
        Set<EntityDetail> schemaElementsAttached = this.getSchemaElementsAttached(userId, glossaryTerm);
        for (EntityDetail schemaElement : schemaElementsAttached) {
            context.putAll((Multimap)Multimaps.forMap(this.assetContextHandler.buildSchemaElementContext(userId, schemaElement)));
        }
        return context;
    }

    private List<Relationship> getGlossariesForCategories(String userId, String glossaryTermGUID, List<Relationship> termCategorization) throws OCFCheckedExceptionBase {
        ArrayList<Relationship> categories = new ArrayList<Relationship>();
        for (Relationship relationship : termCategorization) {
            if (glossaryTermGUID.equals(relationship.getEntityOneProxy().getGUID())) {
                categories.addAll(this.getCategoryAnchor(userId, relationship.getEntityTwoProxy().getGUID()));
                continue;
            }
            categories.addAll(this.getCategoryAnchor(userId, relationship.getEntityOneProxy().getGUID()));
        }
        return categories;
    }

    private List<Relationship> getSemanticAssignments(String userId, String entityGUID, String entityTypeName) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getRelationshipsByType(userId, entityGUID, "SemanticAssignment", entityTypeName);
    }

    private List<Relationship> getTermCategorizations(String userId, String entityGUID, String entityTypeName) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getRelationshipsByType(userId, entityGUID, "TermCategorization", entityTypeName);
    }

    private List<Relationship> getTermAnchors(String userId, String entityGUID) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getRelationshipsByType(userId, entityGUID, "TermAnchor", "GlossaryTerm");
    }

    private List<Relationship> getCategoryAnchor(String userId, String categoryGUID) throws OCFCheckedExceptionBase {
        return this.handlerHelper.getRelationshipsByType(userId, categoryGUID, "CategoryAnchor", "GlossaryCategory");
    }

    public boolean hasGlossaryTermLineageRelationships(String userId, EntityDetail entityDetail) throws OCFCheckedExceptionBase {
        String typeDefName = entityDetail.getType().getTypeDefName();
        String entityDetailGUID = entityDetail.getGUID();
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, entityDetailGUID, typeDefName);
        if (CollectionUtils.isNotEmpty(semanticAssignments)) {
            return true;
        }
        return CollectionUtils.isNotEmpty(this.getTermCategorizations(userId, entityDetailGUID, entityDetail.getType().getTypeDefName()));
    }

    private Set<EntityDetail> getSchemaElementsAttached(String userId, EntityDetail glossaryTerm) throws OCFCheckedExceptionBase {
        List<Relationship> semanticAssignments = this.getSemanticAssignments(userId, glossaryTerm.getGUID(), "GlossaryTerm");
        HashSet<EntityDetail> schemaElements = new HashSet<EntityDetail>();
        for (Relationship semanticAssignment : semanticAssignments) {
            schemaElements.add(this.handlerHelper.getEntityAtTheEnd(userId, glossaryTerm.getGUID(), semanticAssignment));
        }
        return schemaElements;
    }
}

