/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetLineageTypesValidator {
    private final OMRSRepositoryHelper repositoryHelper;
    private final HashSet<String> lineageClassificationTypes = new HashSet();
    private final HashSet<String> lineageRelationshipTypes = new HashSet();

    public AssetLineageTypesValidator(OMRSRepositoryHelper repositoryHelper, Map<String, Object> accessServiceOptions) {
        Object lineageClassificationTypesProperty;
        this.repositoryHelper = repositoryHelper;
        Set<String> defaultLineageClassifications = Set.of("Confidentiality", "AssetZoneMembership", "SubjectArea", "AssetOwnership", "PrimaryCategory", "Incomplete");
        Set<String> defaultDataFileRelationships = Set.of("AttributeForSchema", "AssetSchemaType", "NestedFile", "FolderHierarchy", "ConnectionToAsset", "ConnectionEndpoint");
        Set<String> defaultRelationalTableRelationships = Set.of("NestedSchemaAttribute", "AttributeForSchema", "AssetSchemaType", "DataContentForDataSet", "ConnectionToAsset", "ConnectionEndpoint");
        Set<String> defaultTopicRelationships = Set.of("AttributeForSchema", "SchemaTypeOption", "AssetSchemaType");
        Set<String> defaultProcessRelationships = Set.of("AttributeForSchema", "AssetSchemaType", "PortSchema", "ProcessPort", "ProcessHierarchy", "DataFlow", "LineageMapping");
        Set<String> defaultGlossaryTermRelationships = Set.of("SemanticAssignment", "TermCategorization");
        if (accessServiceOptions != null && (lineageClassificationTypesProperty = accessServiceOptions.get("LineageClassificationTypes")) != null) {
            this.lineageClassificationTypes.addAll((Collection)lineageClassificationTypesProperty);
        }
        this.lineageClassificationTypes.addAll(defaultLineageClassifications);
        this.lineageRelationshipTypes.addAll(defaultDataFileRelationships);
        this.lineageRelationshipTypes.addAll(defaultRelationalTableRelationships);
        this.lineageRelationshipTypes.addAll(defaultTopicRelationships);
        this.lineageRelationshipTypes.addAll(defaultProcessRelationships);
        this.lineageRelationshipTypes.addAll(defaultGlossaryTermRelationships);
    }

    public boolean hasValidClassificationTypes(EntityDetail entityDetail) {
        if (CollectionUtils.isEmpty((Collection)entityDetail.getClassifications())) {
            return false;
        }
        List<String> classificationNames = entityDetail.getClassifications().stream().map(classification -> classification.getType().getTypeDefName()).toList();
        return !Collections.disjoint(this.lineageClassificationTypes, classificationNames);
    }

    public boolean isValidLineageRelationshipType(Relationship relationship) {
        if (this.isRelationshipValid(relationship)) {
            return this.lineageRelationshipTypes.contains(relationship.getType().getTypeDefName());
        }
        return false;
    }

    public boolean isValidLineageEntityType(EntityDetail entityDetail, String serverName) {
        String typeDefName = entityDetail.getType().getTypeDefName();
        return this.repositoryHelper.isTypeOf(serverName, typeDefName, "Asset") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "RelationalTable") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "SchemaAttribute") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "GlossaryTerm") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "Port") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "ComplexSchemaType") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "Connection") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "Endpoint") || this.repositoryHelper.isTypeOf(serverName, typeDefName, "FileFolder");
    }

    public List<Classification> filterLineageClassifications(List<Classification> classifications) {
        if (CollectionUtils.isNotEmpty(classifications)) {
            return classifications.stream().filter(classification -> classification.getType() != null).filter(classification -> this.lineageClassificationTypes.contains(classification.getType().getTypeDefName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isRelationshipValid(Relationship relationship) {
        return relationship.getType() != null && relationship.getType().getTypeDefName() != null && relationship.getEntityOneProxy() != null && relationship.getEntityOneProxy().getType() != null && relationship.getEntityOneProxy().getType().getTypeDefName() != null && relationship.getEntityTwoProxy() != null && relationship.getEntityTwoProxy().getType() != null && relationship.getEntityTwoProxy().getType().getTypeDefName() != null;
    }
}

