/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.odpi.openmetadata.accessservices.assetlineage.auditlog.AssetLineageAuditCode;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventType;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageTypesValidator;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOMRSTopicListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOMRSTopicListener.class);
    private static final String PROCESSING_RELATIONSHIP_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning relationship {} of type {}";
    private static final String PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE = "Asset Lineage OMAS is processing a {} event concerning entity {} of type {}";
    private final AssetLineagePublisher publisher;
    private final AuditLog auditLog;
    private final Converter converter;
    private final String serverName;
    private final AssetLineageTypesValidator assetLineageTypesValidator;

    public AssetLineageOMRSTopicListener(Converter converter, String serverName, AssetLineagePublisher publisher, AssetLineageTypesValidator assetLineageTypesValidator, AuditLog auditLog) {
        this.publisher = publisher;
        this.auditLog = auditLog;
        this.serverName = serverName;
        this.converter = converter;
        this.assetLineageTypesValidator = assetLineageTypesValidator;
    }

    public AssetLineagePublisher getPublisher() {
        return this.publisher;
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
        log.trace("Ignoring registry event: {}", (Object)event);
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        log.trace("Ignoring type event: {}", (Object)event);
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        if (instanceEvent == null) {
            return;
        }
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventOriginator == null) {
            return;
        }
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        EntityDetail entityDetail = instanceEvent.getEntity();
        Relationship relationship = instanceEvent.getRelationship();
        try {
            switch (instanceEventType) {
                case UPDATED_ENTITY_EVENT: {
                    EntityDetail originalEntity = instanceEvent.getOriginalEntity();
                    this.processUpdatedEntity(entityDetail, originalEntity);
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntity(entityDetail);
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    if (entityDetail == null) break;
                    this.processClassifiedEntityEvent(entityDetail);
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    if (entityDetail == null) break;
                    this.processReclassifiedEntityEvent(entityDetail);
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    if (entityDetail == null) break;
                    this.processDeclassifiedEntityEvent(entityDetail);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.processNewRelationshipEvent(relationship);
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.processUpdatedRelationshipEvent(relationship);
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.processDeletedRelationshipEvent(relationship);
                    break;
                }
            }
        }
        catch (OCFCheckedExceptionBase e) {
            log.error("The following exception occurred: \n" + e + "\n \nWhile processing OMRSTopic event: \n" + instanceEvent, (Throwable)e);
            this.logExceptionToAudit(instanceEvent, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("An exception occurred while processing OMRSTopic event: \n " + instanceEvent, (Throwable)e);
            this.logExceptionToAudit(instanceEvent, e);
        }
    }

    private void processUpdatedEntity(EntityDetail entityDetail, EntityDetail originalEntity) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!this.assetLineageTypesValidator.isValidLineageEntityType(entityDetail, this.serverName)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.UPDATE_ENTITY_EVENT.getEventTypeName(), entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
        if (this.isProcessStatusChangedToActive(entityDetail, originalEntity)) {
            if (this.publisher.publishProcessContext(entityDetail).isEmpty()) {
                this.publishEntityEvent(entityDetail, AssetLineageEventType.UPDATE_ENTITY_EVENT);
            }
            log.info("Asset Lineage OMAS published the context for process with guid {}", (Object)entityDetail.getGUID());
        } else {
            this.publishEntityEvent(entityDetail, AssetLineageEventType.UPDATE_ENTITY_EVENT);
        }
    }

    private void processDeletedEntity(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!this.assetLineageTypesValidator.isValidLineageEntityType(entityDetail, this.serverName)) {
            return;
        }
        log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.DELETE_ENTITY_EVENT.getEventTypeName(), entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
        this.publishEntityEvent(entityDetail, AssetLineageEventType.DELETE_ENTITY_EVENT);
    }

    private void processClassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (this.assetLineageTypesValidator.isValidLineageEntityType(entityDetail, this.serverName) && this.assetLineageTypesValidator.hasValidClassificationTypes(entityDetail) && this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT.getEventTypeName(), entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
            this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.CLASSIFICATION_CONTEXT_EVENT);
        }
    }

    private void processReclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (this.assetLineageTypesValidator.isValidLineageEntityType(entityDetail, this.serverName) && this.assetLineageTypesValidator.hasValidClassificationTypes(entityDetail) && this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.RECLASSIFIED_ENTITY_EVENT.getEventTypeName(), entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
            this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.RECLASSIFIED_ENTITY_EVENT);
        }
    }

    private void processDeclassifiedEntityEvent(EntityDetail entityDetail) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (this.assetLineageTypesValidator.isValidLineageEntityType(entityDetail, this.serverName) && this.assetLineageTypesValidator.hasValidClassificationTypes(entityDetail) && this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            log.debug(PROCESSING_ENTITY_DETAIL_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT.getEventTypeName(), entityDetail.getGUID(), entityDetail.getType().getTypeDefName()});
            this.publisher.publishClassificationContext(entityDetail, AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
            this.publishEntityEvent(entityDetail, AssetLineageEventType.DECLASSIFIED_ENTITY_EVENT);
        }
    }

    private void publishEntityEvent(EntityDetail entityDetail, AssetLineageEventType lineageEventType) throws JsonProcessingException, OCFCheckedExceptionBase {
        if (this.publisher.isEntityEligibleForPublishing(entityDetail)) {
            this.publisher.publishLineageEntityEvent(this.converter.createLineageEntity(entityDetail), lineageEventType);
        }
    }

    private void processNewRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (!this.assetLineageTypesValidator.isValidLineageRelationshipType(relationship)) {
            return;
        }
        String relationshipType = relationship.getType().getTypeDefName();
        log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.NEW_RELATIONSHIP_EVENT.getEventTypeName(), relationship.getGUID(), relationship.getType().getTypeDefName()});
        switch (relationshipType) {
            case "SemanticAssignment": 
            case "TermCategorization": {
                String glossaryTermGUID = relationship.getEntityTwoProxy().getGUID();
                this.publisher.publishGlossaryContext(glossaryTermGUID);
                break;
            }
            case "ProcessHierarchy": {
                this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.NEW_RELATIONSHIP_EVENT);
                break;
            }
            case "DataFlow": 
            case "LineageMapping": {
                this.publisher.publishDataFlowOrLineageMappingRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.NEW_RELATIONSHIP_EVENT);
                break;
            }
        }
    }

    private void processUpdatedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (this.assetLineageTypesValidator.isValidLineageRelationshipType(relationship)) {
            log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT.getEventTypeName(), relationship.getGUID(), relationship.getType().getTypeDefName()});
            this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.UPDATE_RELATIONSHIP_EVENT);
        }
    }

    private void processDeletedRelationshipEvent(Relationship relationship) throws OCFCheckedExceptionBase, JsonProcessingException {
        if (this.assetLineageTypesValidator.isValidLineageRelationshipType(relationship)) {
            log.debug(PROCESSING_RELATIONSHIP_DEBUG_MESSAGE, new Object[]{AssetLineageEventType.DELETE_RELATIONSHIP_EVENT.getEventTypeName(), relationship.getGUID(), relationship.getType().getTypeDefName()});
            this.publisher.publishLineageRelationshipEvent(this.converter.createLineageRelationship(relationship), AssetLineageEventType.DELETE_RELATIONSHIP_EVENT);
        }
    }

    private boolean isProcessStatusChangedToActive(EntityDetail entityDetail, EntityDetail originalEntity) {
        return entityDetail.getType().getTypeDefName().equals("Process") && !originalEntity.getStatus().getName().equals(entityDetail.getStatus().getName()) && entityDetail.getStatus().getName().equals("Active");
    }

    private void logExceptionToAudit(OMRSInstanceEvent instanceEvent, Exception e) {
        String actionDescription = "Asset Lineage OMAS is unable to process an OMRSTopic event.";
        this.auditLog.logMessage(actionDescription, AssetLineageAuditCode.EVENT_PROCESSING_EXCEPTION.getMessageDefinition(e.getMessage(), this.serverName, instanceEvent.getInstanceEventType().getName()), instanceEvent.toString());
    }
}

