/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server;

import java.time.Clock;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.converters.GenericStubConverter;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.AssetContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ClassificationHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.GlossaryContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.HandlerHelper;
import org.odpi.openmetadata.accessservices.assetlineage.handlers.ProcessContextHandler;
import org.odpi.openmetadata.accessservices.assetlineage.model.GenericStub;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.AssetLineagePublisher;
import org.odpi.openmetadata.accessservices.assetlineage.outtopic.connector.AssetLineageOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.assetlineage.util.AssetLineageTypesValidator;
import org.odpi.openmetadata.accessservices.assetlineage.util.ClockService;
import org.odpi.openmetadata.accessservices.assetlineage.util.Converter;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetLineageServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription description = AccessServiceDescription.ASSET_LINEAGE_OMAS;
    private final GlossaryContextHandler glossaryContextHandler;
    private final AssetContextHandler assetContextHandler;
    private final ProcessContextHandler processContextHandler;
    private final ClassificationHandler classificationHandler;
    private final HandlerHelper handlerHelper;
    private AssetLineagePublisher assetLineagePublisher;

    public AssetLineageServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, String localServerUserId, AuditLog auditLog, Connection outTopicEventBusConnection, AssetLineageTypesValidator assetLineageTypesValidator) throws NewInstanceException {
        super(description.getAccessServiceFullName(), repositoryConnector, null, null, null, auditLog, localServerUserId, repositoryConnector.getMaxPageSize(), null, null, AssetLineageOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        this.supportedZones = supportedZones;
        if (this.repositoryHandler == null) {
            String methodName = "AssetLineageServicesInstance";
            throw new NewInstanceException(AssetLineageErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        OpenMetadataAPIGenericHandler genericHandler = new OpenMetadataAPIGenericHandler(new GenericStubConverter(this.repositoryHelper, this.serviceName, this.serverName), GenericStub.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, this.defaultZones, this.publishZones, auditLog);
        Converter converter = new Converter(this.repositoryHelper);
        ClockService clockService = new ClockService(Clock.systemUTC());
        this.handlerHelper = new HandlerHelper(this.invalidParameterHandler, this.repositoryHelper, (OpenMetadataAPIGenericHandler<GenericStub>)genericHandler, converter, assetLineageTypesValidator, clockService);
        this.assetContextHandler = new AssetContextHandler((OpenMetadataAPIGenericHandler<GenericStub>)genericHandler, this.handlerHelper, supportedZones, clockService);
        this.processContextHandler = new ProcessContextHandler(this.assetContextHandler, this.handlerHelper, supportedZones);
        this.glossaryContextHandler = new GlossaryContextHandler(this.invalidParameterHandler, this.assetContextHandler, this.handlerHelper);
        this.classificationHandler = new ClassificationHandler(this.invalidParameterHandler, this.handlerHelper);
    }

    GlossaryContextHandler getGlossaryContextHandler() {
        return this.glossaryContextHandler;
    }

    AssetContextHandler getAssetContextHandler() {
        return this.assetContextHandler;
    }

    ProcessContextHandler getProcessContextHandler() {
        return this.processContextHandler;
    }

    ClassificationHandler getClassificationHandler() {
        return this.classificationHandler;
    }

    HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public AssetLineagePublisher getAssetLineagePublisher() {
        return this.assetLineagePublisher;
    }

    public void setAssetLineagePublisher(AssetLineagePublisher assetLineagePublisher) {
        this.assetLineagePublisher = assetLineagePublisher;
    }
}

