/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.model.FindEntitiesParameters;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageRestServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-lineage/users/{userId}/"})
@Tag(name="Asset Lineage OMAS", description="The Asset Lineage OMAS provides services to query the lineage of business terms and data assets.", externalDocs=@ExternalDocumentation(description="Asset Lineage Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-lineage/"))
public class AssetLineageResource {
    private final AssetLineageRestServices restAPI = new AssetLineageRestServices();

    @GetMapping(path={"/publish-entities/{entityType}"})
    public GUIDListResponse publishEntities(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityType, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime updatedAfterDate, @RequestParam(required=false) List<String> entitySubtypeGUIDs, @RequestParam(required=false) List<InstanceStatus> limitResultsByStatus, @RequestParam(required=false) SearchClassifications searchClassifications, @RequestParam(required=false) String sequencingProperty, @RequestParam(required=false) SequencingOrder sequencingOrder) {
        FindEntitiesParameters findEntitiesParameters = new FindEntitiesParameters.Builder().withUpdatedAfter(updatedAfterDate).withEntitySubtypeGUIDs(entitySubtypeGUIDs).withLimitResultsByStatus(limitResultsByStatus).withSearchClassifications(searchClassifications).withSequencingProperty(sequencingProperty).withSequencingOrder(sequencingOrder).build();
        return this.restAPI.publishEntities(serverName, userId, entityType, findEntitiesParameters);
    }

    @GetMapping(path={"/publish-entity/{entityType}/{guid}"})
    public GUIDListResponse publishEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @PathVariable String entityType) {
        return this.restAPI.publishEntity(serverName, userId, entityType, guid);
    }
}

