/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.model.FindEntitiesParameters;
import org.odpi.openmetadata.accessservices.assetlineage.server.AssetLineageRestServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-lineage/users/{userId}/"})
@Tag(name="Asset Lineage OMAS", description="The Asset Lineage OMAS provides services to query the lineage of business terms and data assets.", externalDocs=@ExternalDocumentation(description="Asset Lineage Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-lineage/overview/"))
public class AssetLineageResource {
    private final AssetLineageRestServices restAPI = new AssetLineageRestServices();

    @GetMapping(path={"/publish-entities/{entityType}"})
    @Operation(summary="scanEntitiesByTypeAndPublish", description="Scan the cohort based on the given entity type and publish the contexts for the found entities to the out topic.", externalDocs=@ExternalDocumentation(description="Asset Lineage - Publish Entities", url="https://egeria-project.org/services/omas/asset-lineage/overview/#publish-entities"))
    public GUIDListResponse publishEntities(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityType, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date updatedAfterDate, @RequestParam(required=false) List<String> entitySubtypeGUIDs, @RequestParam(required=false) List<InstanceStatus> limitResultsByStatus, @RequestParam(required=false) SearchClassifications searchClassifications, @RequestParam(required=false) String sequencingProperty, @RequestParam(required=false) SequencingOrder sequencingOrder) {
        FindEntitiesParameters findEntitiesParameters = new FindEntitiesParameters.Builder().withUpdatedAfter(updatedAfterDate).withEntitySubtypeGUIDs(entitySubtypeGUIDs).withLimitResultsByStatus(limitResultsByStatus).withSearchClassifications(searchClassifications).withSequencingProperty(sequencingProperty).withSequencingOrder(sequencingOrder).build();
        return this.restAPI.publishEntities(serverName, userId, entityType, findEntitiesParameters);
    }

    @GetMapping(path={"/publish-entity/{entityType}/{guid}"})
    @Operation(summary="findEntityByGuidAndPublishContext", description="Find the entity by guid and publish the context for it.", externalDocs=@ExternalDocumentation(description="Asset Lineage - Publish Entity", url="https://egeria-project.org/services/omas/asset-lineage/overview/#publish-entity"))
    public GUIDListResponse publishEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @PathVariable String entityType) {
        return this.restAPI.publishEntity(serverName, userId, entityType, guid);
    }

    @GetMapping(path={"/publish-context/{entityType}/{guid}"})
    @Operation(summary="findEntityByGuidAndPublishAssetContext", description="Find the entity by guid and publish the asset context for it. It applies for data tables and files.", externalDocs=@ExternalDocumentation(description="Asset Lineage - Publish Asset Context", url="https://egeria-project.org/services/omas/asset-lineage/overview/#publish-context"))
    public GUIDListResponse publishAssetContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @PathVariable String entityType) {
        return this.restAPI.publishAssetContext(serverName, userId, entityType, guid);
    }

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    @Operation(summary="getOutTopicConnection", description="Return the connection object for the Asset Lineage's OMAS's out topic.", externalDocs=@ExternalDocumentation(description="Asset Lineage - Out Topic Connection", url="https://egeria-project.org/services/omas/asset-lineage/overview/#out-topic-connection"))
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }
}

