/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetlineage.outtopic.connector;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventInterface;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventListener;
import org.odpi.openmetadata.accessservices.assetlineage.ffdc.AssetLineageErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetLineageOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements AssetLineageEventInterface {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageOutTopicClientConnector.class);
    private List<AssetLineageEventListener> internalEventListeners = new ArrayList<AssetLineageEventListener>();

    public synchronized void registerListener(String userId, AssetLineageEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(AssetLineageErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                for (AssetLineageEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(event);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

