/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.samples.assetlookup;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MeaningElement;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetFeedback;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.Certifications;
import org.odpi.openmetadata.frameworks.connectors.properties.Comments;
import org.odpi.openmetadata.frameworks.connectors.properties.Connections;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalIdentifiers;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.InformalTags;
import org.odpi.openmetadata.frameworks.connectors.properties.Licenses;
import org.odpi.openmetadata.frameworks.connectors.properties.Likes;
import org.odpi.openmetadata.frameworks.connectors.properties.Locations;
import org.odpi.openmetadata.frameworks.connectors.properties.NoteLog;
import org.odpi.openmetadata.frameworks.connectors.properties.NoteLogs;
import org.odpi.openmetadata.frameworks.connectors.properties.Ratings;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssets;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Certification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalIdentifier;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.License;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Location;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;

public class AssetLookUp {
    private final String serverName;
    private final String platformURLRoot;
    private final String clientUserId;
    private AssetConsumer client = null;

    private AssetLookUp(String serverName, String platformURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
        try {
            this.client = new AssetConsumer(serverName, platformURLRoot);
        }
        catch (Exception error) {
            System.out.println("There was an exception when creating the Asset Consumer OMAS client.  Error message is: " + error.getMessage());
        }
    }

    private String getPlatformOrigin() {
        try {
            PlatformServicesClient platformServicesClient = new PlatformServicesClient("MyPlatform", this.platformURLRoot);
            return platformServicesClient.getPlatformOrigin(this.clientUserId);
        }
        catch (Exception error) {
            System.out.println("\n\nThere was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.out.println("Ensure the platform URl is correct and the platform is running");
            return null;
        }
    }

    private String[] getUserInput(String requestText) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(requestText);
            String commandLine = br.readLine();
            return commandLine.split(" ");
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when getting user input.  Error message is: " + error.getMessage());
            return null;
        }
    }

    private boolean getRequestForMore(List<String> assetGUIDPage, boolean firstPage) {
        boolean firstAsset = firstPage;
        if (assetGUIDPage != null) {
            for (String assetGUID : assetGUIDPage) {
                if (assetGUID == null) continue;
                this.displayAssetSummary(assetGUID, firstAsset);
                firstAsset = false;
            }
            String[] commandWords = this.getUserInput("Enter 'more' to retrieve next page ... or just return to go back to the main menu");
            return commandWords == null || commandWords.length == 0 || !"more".equals(commandWords[0]);
        }
        return false;
    }

    private void queryAssets(String command, String searchString) {
        try {
            boolean firstPage = true;
            boolean receiveAgain = false;
            int startFrom = 0;
            do {
                List assetGUIDPage = null;
                if (command.equals("get-assets-by-term")) {
                    List meanings = this.client.getMeaningByName(this.clientUserId, searchString, 0, 0);
                    if (meanings == null) continue;
                    System.out.println("Assets for meaning: " + searchString);
                    for (MeaningElement meaning : meanings) {
                        System.out.println("   meaning element: " + meaning.getElementHeader().getGUID());
                        assetGUIDPage = this.client.getAssetsByMeaning(this.clientUserId, meaning.getElementHeader().getGUID(), 0, 0);
                        if (assetGUIDPage == null) continue;
                        startFrom += assetGUIDPage.size();
                        receiveAgain = this.getRequestForMore(assetGUIDPage, firstPage);
                        firstPage = false;
                    }
                } else {
                    if (command.equals("find-assets")) {
                        System.out.println("Find assets containing: " + searchString);
                        assetGUIDPage = this.client.findAssets(this.clientUserId, searchString, startFrom, 5);
                    } else if (command.equals("get-assets-by-name")) {
                        System.out.println("Find assets called: " + searchString);
                        assetGUIDPage = this.client.getAssetsByName(this.clientUserId, searchString, startFrom, 5);
                    } else {
                        System.out.println("Unrecognized command: " + command + " " + searchString);
                    }
                    if (assetGUIDPage == null) {
                        System.out.println();
                        continue;
                    }
                    startFrom += assetGUIDPage.size();
                    receiveAgain = this.getRequestForMore(assetGUIDPage, firstPage);
                    firstPage = false;
                }
            } while (receiveAgain);
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when finding an asset.  Error message is: " + error.getMessage());
        }
        System.out.println();
    }

    private String locateAsset() {
        String command = null;
        try {
            do {
                String requestText;
                String[] commandWords;
                if ((commandWords = this.getUserInput(requestText = "Enter a command along with any optional parameters. Press enter to execute request.\n  - find-assets        <searchString>  \n  - get-assets-by-name <name> \n  - get-assets-by-term <termName> \n  - get-asset          <guid> \n  - exit  \n")) == null) continue;
                if (commandWords.length > 0) {
                    command = commandWords[0];
                }
                if (commandWords.length <= 1) continue;
                if ("get-asset".equals(command)) {
                    return commandWords[1];
                }
                StringBuilder stringBuffer = new StringBuilder();
                for (String commandWord : Arrays.copyOfRange(commandWords, 1, commandWords.length)) {
                    if (commandWord == null) continue;
                    stringBuffer.append(commandWord);
                    stringBuffer.append(" ");
                }
                String searchString = stringBuffer.toString().strip();
                this.queryAssets(command, searchString);
            } while (!"exit".equals(command));
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when locating an asset.  Error message is: " + error.getMessage());
        }
        return null;
    }

    private void displayAssetSummary(String assetGUID, boolean firstAsset) {
        try {
            if (firstAsset) {
                System.out.println("| Unique identifier (GUID)         | Unique name (qualifiedName) | Display name       | Description                  |");
                System.out.println("|----------------------------------+-----------------------------+--------------------+------------------------------|");
            }
            this.client = new AssetConsumer(this.serverName, this.platformURLRoot);
            AssetUniverse assetUniverse = this.client.getAssetProperties(this.clientUserId, assetGUID);
            if (assetUniverse != null) {
                System.out.print("| " + assetUniverse.getGUID());
                System.out.print(" | " + assetUniverse.getQualifiedName());
                System.out.print(" | " + assetUniverse.getDisplayName());
                System.out.print(" | " + assetUniverse.getResourceDescription());
                System.out.println(" |");
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Asset Consumer OMAS client.  Error message is: " + error.getMessage());
        }
    }

    private void displayAsset(String assetGUID) {
        try {
            this.client = new AssetConsumer(this.serverName, this.platformURLRoot);
            this.client.addLikeToAsset(this.clientUserId, assetGUID, true);
            AssetUniverse assetUniverse = this.client.getAssetProperties(this.clientUserId, assetGUID);
            if (assetUniverse != null) {
                RelatedMediaReferences relatedMediaReferences;
                ExternalReferences externalReferences;
                ExternalIdentifiers externalIdentifiers;
                Licenses licenses;
                Certifications certifications;
                NoteLogs noteLogs;
                Locations locations;
                RelatedAssets relatedAssets;
                AssetFeedback feedback;
                SchemaType schemaType;
                List classifications;
                Connections connections;
                Map origins;
                List zoneMembership;
                System.out.println(assetUniverse.getType().getTypeName() + " with GUID: " + assetUniverse.getGUID());
                System.out.println("   " + assetUniverse.getType().getTypeName() + " inherits from " + assetUniverse.getType().getSuperTypeNames());
                System.out.println("   qualifiedName: " + assetUniverse.getQualifiedName());
                System.out.println("   displayName: " + assetUniverse.getDisplayName());
                System.out.println("   resourceName: " + assetUniverse.getResourceName());
                System.out.println("   description: " + assetUniverse.getResourceDescription());
                String owner = assetUniverse.getOwner();
                if (owner != null) {
                    System.out.println("   owner: " + owner + " (propertyName: " + assetUniverse.getOwnerPropertyName() + " from " + assetUniverse.getOwnerTypeName() + ")");
                }
                if ((zoneMembership = assetUniverse.getZoneMembership()) == null) {
                    System.out.println("   zone membership: all zones" + assetUniverse.getResourceName());
                } else {
                    System.out.println("   zone membership: " + zoneMembership);
                }
                List meanings = assetUniverse.getMeanings();
                if (meanings != null) {
                    System.out.println("   assigned meanings: ");
                    for (Meaning meaning : meanings) {
                        if (meaning == null) continue;
                        System.out.println("      * " + meaning.getName() + " - " + meaning.getDescription());
                    }
                }
                if ((origins = assetUniverse.getAssetOrigin()) != null) {
                    System.out.println("   digital resource origins: ");
                    for (String originName : origins.keySet()) {
                        if (originName == null) continue;
                        System.out.println("      * " + originName + " - " + (String)origins.get(originName));
                    }
                }
                if ((connections = assetUniverse.getConnections()) != null) {
                    System.out.println("   connections: ");
                    while (connections.hasNext()) {
                        Connection connection = connections.next();
                        if (connection == null) continue;
                        System.out.println("      * " + connection.getDisplayName() + ":");
                        if (connection.getEndpoint() != null) {
                            System.out.println("          - endpoint address: " + connection.getEndpoint().getAddress());
                        }
                        if (connection.getConnectorType() == null) continue;
                        System.out.println("          - connector implementation: " + connection.getConnectorType().getConnectorProviderClassName());
                    }
                }
                if ((classifications = assetUniverse.getClassifications()) != null) {
                    System.out.println("   classifications: ");
                    for (ElementClassification classification : classifications) {
                        if (classification == null) continue;
                        System.out.println("      * " + classification.getClassificationName() + " - " + classification.getClassificationProperties());
                    }
                }
                if ((schemaType = assetUniverse.getSchema()) != null) {
                    System.out.println("   schema: " + schemaType.getDisplayName());
                }
                if ((feedback = assetUniverse.getFeedback()) != null) {
                    Ratings ratings;
                    Likes likes;
                    InformalTags informalTags;
                    Comments comments = feedback.getComments();
                    if (comments != null) {
                        System.out.println("   comments: ");
                        while (comments.hasNext()) {
                            Comment comment = comments.next();
                            if (comment == null) continue;
                            System.out.println("      * " + comment.getUser() + " commented: " + comment.getCommentText());
                        }
                    }
                    if ((informalTags = feedback.getInformalTags()) != null) {
                        System.out.println("   informal tags: ");
                        while (informalTags.hasNext()) {
                            InformalTag informalTag = informalTags.next();
                            if (informalTag == null) continue;
                            System.out.println("      * " + informalTag.getName() + " - " + informalTag.getDescription());
                        }
                    }
                    if ((likes = feedback.getLikes()) != null) {
                        System.out.println("   likes: ");
                        while (likes.hasNext()) {
                            Like like = likes.next();
                            if (like == null) continue;
                            System.out.println("      * Like from " + like.getUser());
                        }
                    }
                    if ((ratings = feedback.getRatings()) != null) {
                        System.out.println("   ratings: ");
                        while (ratings.hasNext()) {
                            Rating rating = ratings.next();
                            if (rating == null) continue;
                            System.out.println("      * " + rating.getStarRating() + " from " + rating.getUser());
                        }
                    }
                }
                if ((relatedAssets = assetUniverse.getRelatedAssets()) != null) {
                    System.out.println("   related assets: ");
                    while (relatedAssets.hasNext()) {
                        RelatedAsset relatedAsset = relatedAssets.next();
                        if (relatedAsset == null) continue;
                        System.out.println("      * " + relatedAsset.getAttributeName() + " (" + relatedAsset.getRelationshipName() + ") - " + relatedAsset.getDisplayName() + " - " + relatedAsset.getGUID());
                    }
                }
                if ((locations = assetUniverse.getKnownLocations()) != null) {
                    System.out.println("   locations: ");
                    while (locations.hasNext()) {
                        Location location = locations.next();
                        if (location == null) continue;
                        System.out.println("      * " + location.getDisplayName());
                    }
                }
                if ((noteLogs = assetUniverse.getNoteLogs()) != null) {
                    System.out.println("   notelogs: ");
                    while (noteLogs.hasNext()) {
                        NoteLog noteLog = noteLogs.next();
                        if (noteLog == null) continue;
                        System.out.println("      * " + noteLog.getDisplayName());
                    }
                }
                if ((certifications = assetUniverse.getCertifications()) != null) {
                    System.out.println("   certifications: ");
                    while (certifications.hasNext()) {
                        Certification certification = certifications.next();
                        if (certification == null) continue;
                        System.out.println("      * " + certification.getSummary());
                    }
                }
                if ((licenses = assetUniverse.getLicenses()) != null) {
                    System.out.println("   licenses: ");
                    while (licenses.hasNext()) {
                        License license = licenses.next();
                        if (license == null) continue;
                        System.out.println("      * " + license.getSummary());
                    }
                }
                if ((externalIdentifiers = assetUniverse.getExternalIdentifiers()) != null) {
                    System.out.println("   external identifiers: ");
                    while (externalIdentifiers.hasNext()) {
                        ExternalIdentifier externalIdentifier = externalIdentifiers.next();
                        if (externalIdentifier == null) continue;
                        System.out.println("      * " + externalIdentifier.getIdentifier() + " - from : " + externalIdentifier.getScope().getQualifiedName());
                    }
                }
                if ((externalReferences = assetUniverse.getExternalReferences()) != null) {
                    System.out.println("   external references: ");
                    while (externalReferences.hasNext()) {
                        ExternalReference externalReference = externalReferences.next();
                        if (externalReference == null) continue;
                        System.out.println("      * " + externalReference.getDisplayName() + " - " + externalReference.getURI());
                    }
                }
                if ((relatedMediaReferences = assetUniverse.getRelatedMediaReferences()) != null) {
                    System.out.println("   related media references: ");
                    while (relatedMediaReferences.hasNext()) {
                        RelatedMediaReference relatedMediaReference = relatedMediaReferences.next();
                        if (relatedMediaReference == null) continue;
                        System.out.println("      * " + relatedMediaReference.getDisplayName() + " - " + relatedMediaReference.getMediaType());
                    }
                }
                System.out.println("   additionalProperties: " + assetUniverse.getAdditionalProperties());
                Map extendedProperties = assetUniverse.getExtendedProperties();
                if (extendedProperties != null) {
                    System.out.println("   extendedProperties: " + extendedProperties);
                }
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Asset Consumer OMAS client.  Error message is: " + error.getMessage());
        }
    }

    public static void main(String[] args) {
        String interactiveMode = "interactive";
        String endInteractiveMode = "exit";
        String serverName = "mds1";
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "garygeeke";
        String mode = "interactive";
        if (args.length > 0) {
            serverName = args[0];
        }
        if (args.length > 1) {
            platformURLRoot = args[1];
        }
        if (args.length > 2) {
            clientUserId = args[2];
        }
        if (args.length > 3) {
            mode = args[3];
        }
        System.out.println("===============================");
        System.out.println("Asset Look Up   " + new Date());
        System.out.println("===============================");
        System.out.print("Running against server: " + serverName + " at " + platformURLRoot);
        AssetLookUp utility = new AssetLookUp(serverName, platformURLRoot, clientUserId);
        HttpHelper.noStrictSSLIfConfigured();
        String platformOrigin = utility.getPlatformOrigin();
        if (platformOrigin != null) {
            System.out.print(" - " + platformOrigin);
        } else {
            System.out.println();
            System.exit(-1);
        }
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        try {
            if ("interactive".equals(mode)) {
                while (!"exit".equals(mode)) {
                    String assetGUID = utility.locateAsset();
                    if (assetGUID != null) {
                        utility.displayAsset(assetGUID);
                    } else {
                        mode = "exit";
                    }
                    System.out.println();
                }
            } else {
                utility.displayAsset(mode);
            }
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

