/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples;

import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.governanceprogram.samples.GovernanceZoneSampleDefinitions;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CreateGovernanceZoneSample {
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;
    private AssetOwner client = null;

    private CreateGovernanceZoneSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void createZone(String zoneName, String displayName, String description, String criteria) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        System.out.println("------------------------------------------------------------------------");
        System.out.println(zoneName);
        System.out.println("------------------------------------------------------------------------");
        System.out.println(" ==> qualifiedName: " + zoneName);
        System.out.println(" ==> displayName:   " + displayName);
        System.out.println(" ==> description:   " + description);
        System.out.println(" ==> criteria:      " + criteria);
        System.out.println(" ");
        this.client.createGovernanceZone(this.clientUserId, zoneName, displayName, description, criteria, null);
    }

    private void run() {
        try {
            GovernanceZoneSampleDefinitions[] zoneSampleDefinitions;
            this.client = new AssetOwner(this.serverName, this.serverURLRoot);
            for (GovernanceZoneSampleDefinitions zoneDefinition : zoneSampleDefinitions = GovernanceZoneSampleDefinitions.values()) {
                this.createZone(zoneDefinition.getZoneName(), zoneDefinition.getDisplayName(), zoneDefinition.getDescription(), zoneDefinition.getCriteria());
            }
        }
        catch (Throwable error) {
            System.out.println("There was an exception when calling the asset owner client.  Error message is: " + error.getMessage());
        }
    }

    public static void main(String[] args) {
        String serverName = "cocoMDS1";
        String serverURLRoot = "http://localhost:8080";
        String clientUserId = "garygeeke";
        if (args.length > 1) {
            serverName = args[1];
        }
        if (args.length > 2) {
            serverURLRoot = args[2];
        }
        if (args.length > 3) {
            clientUserId = args[3];
        }
        System.out.println("===============================");
        System.out.println("Create Governance Zones Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        try {
            CreateGovernanceZoneSample sample = new CreateGovernanceZoneSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

