/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.samples.discoveryservices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.frameworks.discovery.properties.DataProfileAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SchemaAnalysisAnnotation;

public class DropFootWeeklyMeasurementsDiscoveryService
extends DiscoveryService {
    private static final String STRING_TYPE_NAME = "string";
    private static final String CHAR_TYPE_NAME = "char";
    private static final String DATE_TYPE_NAME = "date";
    private static final String INT_TYPE_NAME = "int";
    private static final String LONG_TYPE_NAME = "long";
    private static final String BOOLEAN_TYPE_NAME = "boolean";
    private static final String FLOAT_TYPE_NAME = "float";
    private static final String BOOLEAN_UC_TRUE = "TRUE";
    private static final String BOOLEAN_LC_TRUE = "true";
    private static final String BOOLEAN_UC_FALSE = "FALSE";
    private static final String BOOLEAN_LC_FALSE = "false";

    private String getDataFieldType(String existingType, String newFieldValue) {
        if (STRING_TYPE_NAME.equals(existingType)) {
            return STRING_TYPE_NAME;
        }
        if (newFieldValue == null) {
            return existingType;
        }
        if (BOOLEAN_LC_TRUE.equals(newFieldValue) || BOOLEAN_UC_TRUE.equals(newFieldValue) || BOOLEAN_LC_FALSE.equals(newFieldValue) || BOOLEAN_UC_FALSE.equals(newFieldValue)) {
            if (existingType == null || existingType.equals(BOOLEAN_TYPE_NAME)) {
                return BOOLEAN_TYPE_NAME;
            }
            return STRING_TYPE_NAME;
        }
        return STRING_TYPE_NAME;
    }

    private Map<String, Integer> getValueCount(Map<String, Integer> existingValueCount, String newFieldValue) {
        if (existingValueCount == null) {
            HashMap<String, Integer> newValueCount = new HashMap<String, Integer>();
            newValueCount.put(newFieldValue, 1);
            return newValueCount;
        }
        Integer countForValue = existingValueCount.get(newFieldValue);
        if (countForValue == null) {
            existingValueCount.put(newFieldValue, 1);
        } else {
            existingValueCount.put(newFieldValue, countForValue + 1);
        }
        return existingValueCount;
    }

    private List<String> getValueList(List<String> existingValueList, String newFieldValue) {
        if (existingValueList == null) {
            ArrayList<String> newValueList = new ArrayList<String>();
            newValueList.add(newFieldValue);
            return newValueList;
        }
        if (!existingValueList.contains(newFieldValue)) {
            existingValueList.add(newFieldValue);
        }
        return existingValueList;
    }

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CSVFileStoreConnector assetConnector = (CSVFileStoreConnector)this.discoveryContext.getAssetStore().getConnectorToAsset();
            DiscoveryAnnotationStore annotationStore = this.discoveryContext.getAnnotationStore();
            int size = 0;
            int delimiterCount = 0;
            long recordCount = assetConnector.getRecordCount();
            SchemaAnalysisAnnotation schemaAnnotation = new SchemaAnalysisAnnotation();
            schemaAnnotation.setSchemaName("CSV");
            schemaAnnotation.setSchemaTypeName("TabularSchemaType");
            schemaAnnotation.setAnnotationStatus(AnnotationStatus.NEW_ANNOTATION);
            String schemaAnnotationGUID = annotationStore.addAnnotationToDiscoveryReport((Annotation)schemaAnnotation);
            List columnNames = assetConnector.getColumnNames();
            HashMap<Integer, DataField> dataFields = new HashMap<Integer, DataField>();
            HashMap<Integer, DataProfileAnnotation> dataProfiles = new HashMap<Integer, DataProfileAnnotation>();
            if (columnNames != null) {
                int position = 0;
                for (String columnName : columnNames) {
                    if (columnName == null) continue;
                    DataField dataField = new DataField();
                    dataField.setDataFieldPosition(position);
                    dataField.setDataFieldName(columnName);
                    dataFields.put(position, dataField);
                    DataProfileAnnotation dataProfile = new DataProfileAnnotation();
                    dataProfiles.put(position, dataProfile);
                    size += columnName.length();
                    ++position;
                }
                if (position > 0) {
                    delimiterCount = position - 1;
                }
                size += delimiterCount;
                int recordNumber = 0;
                while ((long)recordNumber < recordCount) {
                    List recordValues = assetConnector.readRecord(recordNumber);
                    if (recordValues != null && !recordValues.isEmpty()) {
                        int columnPosition = 0;
                        int recordLength = 0;
                        for (String fieldValue : recordValues) {
                            DataField dataField = (DataField)dataFields.get(columnPosition);
                            DataProfileAnnotation dataProfile = (DataProfileAnnotation)dataProfiles.get(columnPosition);
                            dataField.setDataFieldType(this.getDataFieldType(dataField.getDataFieldType(), fieldValue));
                            dataProfile.setValueCount(this.getValueCount(dataProfile.getValueCount(), fieldValue));
                            dataProfile.setValueList(this.getValueList(dataProfile.getValueList(), fieldValue));
                            recordLength += fieldValue.length();
                            ++columnPosition;
                        }
                        size = size + recordLength + delimiterCount;
                    }
                    ++recordNumber;
                }
                for (int columnNumber = 0; columnNumber < columnNames.size(); ++columnNumber) {
                    String dataFieldGUID = annotationStore.addDataFieldToDiscoveryReport(schemaAnnotationGUID, (DataField)dataFields.get(columnNumber));
                    annotationStore.addAnnotationToDataField(dataFieldGUID, (Annotation)dataProfiles.get(columnNumber));
                }
            }
            DataSourcePhysicalStatusAnnotation measurementAnnotation = new DataSourcePhysicalStatusAnnotation();
            HashMap<String, String> measurementProperties = new HashMap<String, String>();
            measurementProperties.put("FileName", assetConnector.getFileName());
            measurementProperties.put("RecordCount", Long.toString(recordCount));
            measurementAnnotation.setModifiedTime(assetConnector.getLastUpdateDate());
            measurementAnnotation.setDataSourceProperties(measurementProperties);
            measurementAnnotation.setSize(size);
            annotationStore.addAnnotationToDiscoveryReport((Annotation)measurementAnnotation);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Throwable error) {
            super.handleUnexpectedException("start", error);
        }
    }
}

