/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum KeyPattern implements Serializable
{
    LOCAL_KEY(0, 0, "Local Key", "Unique key allocated and used within the scope of a single system."),
    RECYCLED_KEY(1, 1, "Recycled Key", "Key allocated and used within the scope of a single system that is periodically reused for different records."),
    NATURAL_KEY(2, 2, "Natural Key", "Key derived from an attribute of the entity, such as email address, passport number."),
    MIRROR_KEY(3, 3, "Mirror Key", "Key value copied from another system."),
    AGGREGATE_KEY(4, 4, "Aggregate Key", "Key formed by combining keys from multiple systems."),
    CALLERS_KEY(5, 5, "Caller's Key", "Key from another system can bey used if system name provided."),
    STABLE_KEY(6, 6, "Stable Key", "Key value will remain active even if records are merged."),
    OTHER(99, 99, "Other", "Another key pattern.");

    public static final String ENUM_TYPE_GUID = "8904df8f-1aca-4de8-9abd-1ef2aadba300";
    public static final String ENUM_TYPE_NAME = "KeyPattern";
    private int ordinal;
    private int openTypeOrdinal;
    private String name;
    private String description;
    private static final long serialVersionUID = 1L;

    private KeyPattern(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "KeyPattern{openTypeOrdinal=" + this.openTypeOrdinal + ", ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", openTypeGUID='" + this.getOpenTypeGUID() + '\'' + ", openTypeName='" + this.getOpenTypeName() + '\'' + '}';
    }
}

