/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetmanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAttributeProperties.class, name="SchemaAttributeProperties"), @JsonSubTypes.Type(value=SchemaTypeProperties.class, name="SchemaTypeProperties")})
public class SchemaProperties
extends SupplementaryProperties {
    private static final long serialVersionUID = 1L;
    private boolean isDeprecated = false;
    private String technicalName = null;
    private String technicalDescription = null;

    public SchemaProperties() {
    }

    public SchemaProperties(SchemaProperties template) {
        super(template);
        if (template != null) {
            this.isDeprecated = template.getIsDeprecated();
            this.technicalName = template.getTechnicalName();
            this.technicalDescription = template.getTechnicalDescription();
        }
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String name) {
        this.technicalName = name;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setTechnicalDescription(String technicalDescription) {
        this.technicalDescription = technicalDescription;
    }

    @Override
    public String toString() {
        return "SchemaProperties{isDeprecated=" + this.isDeprecated + ", technicalName='" + this.technicalName + '\'' + ", technicalDescription='" + this.technicalDescription + '\'' + ", displayName='" + this.getDisplayName() + '\'' + ", summary='" + this.getSummary() + '\'' + ", description='" + this.getDescription() + '\'' + ", abbreviation='" + this.getAbbreviation() + '\'' + ", usage='" + this.getUsage() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaProperties that = (SchemaProperties)objectToCompare;
        return this.isDeprecated == that.isDeprecated && Objects.equals(this.technicalName, that.technicalName) && Objects.equals(this.technicalDescription, that.technicalDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDeprecated, this.technicalName, this.technicalDescription);
    }
}

